"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const kysely_1 = require("kysely");
async function up(db) {
    await (0, kysely_1.sql) `INSERT INTO "asset_file" ("assetId", "path", "type")
            SELECT
            id, "sidecarPath", 'sidecar'
            FROM "asset"
            WHERE "sidecarPath" IS NOT NULL AND "sidecarPath" != '';`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "asset" DROP COLUMN "sidecarPath";`.execute(db);
}
async function down(db) {
    await (0, kysely_1.sql) `ALTER TABLE "asset" ADD "sidecarPath" character varying;`.execute(db);
    await (0, kysely_1.sql) `
      UPDATE "asset"
      SET "sidecarPath" = "asset_file"."path"
      FROM "asset_file"
      WHERE "asset"."id" = "asset_file"."assetId" AND "asset_file"."type" = 'sidecar';
    `.execute(db);
    await (0, kysely_1.sql) `DELETE FROM "asset_file" WHERE "type" = 'sidecar';`.execute(db);
}
//# sourceMappingURL=1764698859174-SidecarInAssetFile.js.map