import { PluginTriggerType } from 'src/enum';
import { Generated, Timestamp } from 'src/sql-tools';
import type { ActionConfig, FilterConfig } from 'src/types/plugin-schema.types';
export declare class WorkflowTable {
    id: Generated<string>;
    ownerId: string;
    triggerType: PluginTriggerType;
    name: string | null;
    description: string;
    createdAt: Generated<Timestamp>;
    enabled: boolean;
}
export declare class WorkflowFilterTable {
    id: Generated<string>;
    workflowId: Generated<string>;
    pluginFilterId: string;
    filterConfig: FilterConfig | null;
    order: number;
}
export declare class WorkflowActionTable {
    id: Generated<string>;
    workflowId: Generated<string>;
    pluginActionId: string;
    actionConfig: ActionConfig | null;
    order: number;
}
