"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkflowActionTable = exports.WorkflowFilterTable = exports.WorkflowTable = void 0;
const enum_1 = require("../../enum");
const plugin_table_1 = require("./plugin.table");
const user_table_1 = require("./user.table");
const sql_tools_1 = require("../../sql-tools");
let WorkflowTable = class WorkflowTable {
    id;
    ownerId;
    triggerType;
    name;
    description;
    createdAt;
    enabled;
};
exports.WorkflowTable = WorkflowTable;
__decorate([
    (0, sql_tools_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Object)
], WorkflowTable.prototype, "id", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => user_table_1.UserTable, { onDelete: 'CASCADE', onUpdate: 'CASCADE', nullable: false }),
    __metadata("design:type", String)
], WorkflowTable.prototype, "ownerId", void 0);
__decorate([
    (0, sql_tools_1.Column)(),
    __metadata("design:type", String)
], WorkflowTable.prototype, "triggerType", void 0);
__decorate([
    (0, sql_tools_1.Column)({ nullable: true }),
    __metadata("design:type", Object)
], WorkflowTable.prototype, "name", void 0);
__decorate([
    (0, sql_tools_1.Column)(),
    __metadata("design:type", String)
], WorkflowTable.prototype, "description", void 0);
__decorate([
    (0, sql_tools_1.CreateDateColumn)(),
    __metadata("design:type", Object)
], WorkflowTable.prototype, "createdAt", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'boolean', default: true }),
    __metadata("design:type", Boolean)
], WorkflowTable.prototype, "enabled", void 0);
exports.WorkflowTable = WorkflowTable = __decorate([
    (0, sql_tools_1.Table)('workflow')
], WorkflowTable);
let WorkflowFilterTable = class WorkflowFilterTable {
    id;
    workflowId;
    pluginFilterId;
    filterConfig;
    order;
};
exports.WorkflowFilterTable = WorkflowFilterTable;
__decorate([
    (0, sql_tools_1.PrimaryGeneratedColumn)('uuid'),
    __metadata("design:type", Object)
], WorkflowFilterTable.prototype, "id", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => WorkflowTable, { onDelete: 'CASCADE', onUpdate: 'CASCADE' }),
    __metadata("design:type", Object)
], WorkflowFilterTable.prototype, "workflowId", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => plugin_table_1.PluginFilterTable, { onDelete: 'CASCADE', onUpdate: 'CASCADE' }),
    __metadata("design:type", String)
], WorkflowFilterTable.prototype, "pluginFilterId", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'jsonb', nullable: true }),
    __metadata("design:type", Object)
], WorkflowFilterTable.prototype, "filterConfig", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'integer' }),
    __metadata("design:type", Number)
], WorkflowFilterTable.prototype, "order", void 0);
exports.WorkflowFilterTable = WorkflowFilterTable = __decorate([
    (0, sql_tools_1.Index)({ columns: ['workflowId', 'order'] }),
    (0, sql_tools_1.Index)({ columns: ['pluginFilterId'] }),
    (0, sql_tools_1.Table)('workflow_filter')
], WorkflowFilterTable);
let WorkflowActionTable = class WorkflowActionTable {
    id;
    workflowId;
    pluginActionId;
    actionConfig;
    order;
};
exports.WorkflowActionTable = WorkflowActionTable;
__decorate([
    (0, sql_tools_1.PrimaryGeneratedColumn)('uuid'),
    __metadata("design:type", Object)
], WorkflowActionTable.prototype, "id", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => WorkflowTable, { onDelete: 'CASCADE', onUpdate: 'CASCADE' }),
    __metadata("design:type", Object)
], WorkflowActionTable.prototype, "workflowId", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => plugin_table_1.PluginActionTable, { onDelete: 'CASCADE', onUpdate: 'CASCADE' }),
    __metadata("design:type", String)
], WorkflowActionTable.prototype, "pluginActionId", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'jsonb', nullable: true }),
    __metadata("design:type", Object)
], WorkflowActionTable.prototype, "actionConfig", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'integer' }),
    __metadata("design:type", Number)
], WorkflowActionTable.prototype, "order", void 0);
exports.WorkflowActionTable = WorkflowActionTable = __decorate([
    (0, sql_tools_1.Index)({ columns: ['workflowId', 'order'] }),
    (0, sql_tools_1.Index)({ columns: ['pluginActionId'] }),
    (0, sql_tools_1.Table)('workflow_action')
], WorkflowActionTable);
//# sourceMappingURL=workflow.table.js.map