import { BulkIdResponseDto, BulkIdsDto } from 'src/dtos/asset-ids.response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { MemoryCreateDto, MemoryResponseDto, MemorySearchDto, MemoryUpdateDto } from 'src/dtos/memory.dto';
import { BaseService } from 'src/services/base.service';
export declare class MemoryService extends BaseService {
    onMemoriesCreate(): Promise<void>;
    private createOnThisDayMemories;
    onMemoriesCleanup(): Promise<void>;
    search(auth: AuthDto, dto: MemorySearchDto): Promise<MemoryResponseDto[]>;
    statistics(auth: AuthDto, dto: MemorySearchDto): Promise<{
        total: number;
    }>;
    get(auth: AuthDto, id: string): Promise<MemoryResponseDto>;
    create(auth: AuthDto, dto: MemoryCreateDto): Promise<MemoryResponseDto>;
    update(auth: AuthDto, id: string, dto: MemoryUpdateDto): Promise<MemoryResponseDto>;
    remove(auth: AuthDto, id: string): Promise<void>;
    addAssets(auth: AuthDto, id: string, dto: BulkIdsDto): Promise<BulkIdResponseDto[]>;
    removeAssets(auth: AuthDto, id: string, dto: BulkIdsDto): Promise<BulkIdResponseDto[]>;
    private findOrFail;
}
