import { ExifDateTime } from 'exiftool-vendored';
import { JobName, JobStatus } from 'src/enum';
import { ArgOf } from 'src/repositories/event.repository';
import { ImmichTags } from 'src/repositories/metadata.repository';
import { BaseService } from 'src/services/base.service';
import { JobOf } from 'src/types';
export declare function firstDateTime(tags: ImmichTags): {
    tag: keyof ImmichTags;
    dateTime: ExifDateTime;
} | undefined;
export declare class MetadataService extends BaseService {
    onBootstrap(): Promise<void>;
    onShutdown(): Promise<void>;
    onConfigInit({ newConfig }: ArgOf<'ConfigInit'>): void;
    onConfigUpdate({ newConfig }: ArgOf<'ConfigUpdate'>): void;
    private init;
    private linkLivePhotos;
    handleQueueMetadataExtraction(job: JobOf<JobName.AssetExtractMetadataQueueAll>): Promise<JobStatus>;
    handleMetadataExtraction(data: JobOf<JobName.AssetExtractMetadata>): Promise<void>;
    handleQueueSidecar({ force }: JobOf<JobName.SidecarQueueAll>): Promise<JobStatus>;
    handleSidecarCheck({ id }: JobOf<JobName.SidecarCheck>): Promise<JobStatus | undefined>;
    handleTagAsset({ assetId }: ArgOf<'AssetTag'>): Promise<void>;
    handleUntagAsset({ assetId }: ArgOf<'AssetUntag'>): Promise<void>;
    handleSidecarWrite(job: JobOf<JobName.SidecarWrite>): Promise<JobStatus>;
    private getSidecarCandidates;
    private getImageDimensions;
    private getExifTags;
    private getTagList;
    private applyTagList;
    private isMotionPhoto;
    private applyMotionPhotos;
    private hasTaggedFaces;
    private orientRegionInfo;
    private applyTaggedFaces;
    private getDates;
    private hasGeo;
    private getAutoStackId;
    private getBitsPerSample;
    private getDuration;
    private getVideoTags;
}
