"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationAdminService = void 0;
const common_1 = require("@nestjs/common");
const notification_dto_1 = require("../dtos/notification.dto");
const enum_1 = require("../enum");
const email_repository_1 = require("../repositories/email.repository");
const base_service_1 = require("./base.service");
const misc_1 = require("../utils/misc");
let NotificationAdminService = class NotificationAdminService extends base_service_1.BaseService {
    async create(auth, dto) {
        const item = await this.notificationRepository.create({
            userId: dto.userId,
            type: dto.type ?? enum_1.NotificationType.Custom,
            level: dto.level ?? enum_1.NotificationLevel.Info,
            title: dto.title,
            description: dto.description,
            data: dto.data,
        });
        return (0, notification_dto_1.mapNotification)(item);
    }
    async sendTestEmail(id, dto, tempTemplate) {
        const user = await this.userRepository.get(id, { withDeleted: false });
        if (!user) {
            throw new Error('User not found');
        }
        try {
            await this.emailRepository.verifySmtp(dto.transport);
        }
        catch (error) {
            throw new common_1.BadRequestException('Failed to verify SMTP configuration', { cause: error });
        }
        const { server } = await this.getConfig({ withCache: false });
        const { html, text } = await this.emailRepository.renderEmail({
            template: email_repository_1.EmailTemplate.TEST_EMAIL,
            data: {
                baseUrl: (0, misc_1.getExternalDomain)(server),
                displayName: user.name,
            },
            customTemplate: tempTemplate,
        });
        const { messageId } = await this.emailRepository.sendEmail({
            to: user.email,
            subject: 'Test email from Immich',
            html,
            text,
            from: dto.from,
            replyTo: dto.replyTo || dto.from,
            smtp: dto.transport,
        });
        return { messageId };
    }
    async getTemplate(name, customTemplate) {
        const { server, templates } = await this.getConfig({ withCache: false });
        let templateResponse = '';
        switch (name) {
            case email_repository_1.EmailTemplate.WELCOME: {
                const { html: _welcomeHtml } = await this.emailRepository.renderEmail({
                    template: email_repository_1.EmailTemplate.WELCOME,
                    data: {
                        baseUrl: (0, misc_1.getExternalDomain)(server),
                        displayName: 'John Doe',
                        username: 'john@doe.com',
                        password: 'thisIsAPassword123',
                    },
                    customTemplate: customTemplate || templates.email.welcomeTemplate,
                });
                templateResponse = _welcomeHtml;
                break;
            }
            case email_repository_1.EmailTemplate.ALBUM_UPDATE: {
                const { html: _updateAlbumHtml } = await this.emailRepository.renderEmail({
                    template: email_repository_1.EmailTemplate.ALBUM_UPDATE,
                    data: {
                        baseUrl: (0, misc_1.getExternalDomain)(server),
                        albumId: '1',
                        albumName: 'Favorite Photos',
                        recipientName: 'Jane Doe',
                        cid: undefined,
                    },
                    customTemplate: customTemplate || templates.email.albumInviteTemplate,
                });
                templateResponse = _updateAlbumHtml;
                break;
            }
            case email_repository_1.EmailTemplate.ALBUM_INVITE: {
                const { html } = await this.emailRepository.renderEmail({
                    template: email_repository_1.EmailTemplate.ALBUM_INVITE,
                    data: {
                        baseUrl: (0, misc_1.getExternalDomain)(server),
                        albumId: '1',
                        albumName: "John Doe's Favorites",
                        senderName: 'John Doe',
                        recipientName: 'Jane Doe',
                        cid: undefined,
                    },
                    customTemplate: customTemplate || templates.email.albumInviteTemplate,
                });
                templateResponse = html;
                break;
            }
            default: {
                templateResponse = '';
                break;
            }
        }
        return { name, html: templateResponse };
    }
};
exports.NotificationAdminService = NotificationAdminService;
exports.NotificationAdminService = NotificationAdminService = __decorate([
    (0, common_1.Injectable)()
], NotificationAdminService);
//# sourceMappingURL=notification-admin.service.js.map