import { CurrentPlugin } from '@extism/extism';
import { Updateable } from 'kysely';
import { AccessRepository } from 'src/repositories/access.repository';
import { AlbumRepository } from 'src/repositories/album.repository';
import { AssetRepository } from 'src/repositories/asset.repository';
import { CryptoRepository } from 'src/repositories/crypto.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { AssetTable } from 'src/schema/tables/asset.table';
export declare class PluginHostFunctions {
    private assetRepository;
    private albumRepository;
    private accessRepository;
    private cryptoRepository;
    private logger;
    private pluginJwtSecret;
    constructor(assetRepository: AssetRepository, albumRepository: AlbumRepository, accessRepository: AccessRepository, cryptoRepository: CryptoRepository, logger: LoggingRepository, pluginJwtSecret: string);
    getHostFunctions(): {
        'extism:host/user': {
            updateAsset: (cp: CurrentPlugin, offs: bigint) => Promise<void>;
            addAssetToAlbum: (cp: CurrentPlugin, offs: bigint) => Promise<void>;
        };
    };
    private handleUpdateAsset;
    private handleAddAssetToAlbum;
    private validateToken;
    updateAsset(input: {
        authToken: string;
    } & Updateable<AssetTable> & {
        id: string;
    }): Promise<void>;
    addAssetToAlbum(input: {
        authToken: string;
        assetId: string;
        albumId: string;
    }): Promise<number>;
}
