import { DatabaseColumn, Reason, SchemaDiff } from 'src/sql-tools/types';
export declare const compareColumns: {
    getRenameKey: (column: DatabaseColumn) => string;
    onRename: (source: DatabaseColumn, target: DatabaseColumn) => {
        type: "ColumnRename";
        tableName: string;
        oldName: string;
        newName: string;
        reason: Reason;
    }[];
    onMissing: (source: DatabaseColumn) => {
        type: "ColumnAdd";
        column: DatabaseColumn;
        reason: Reason;
    }[];
    onExtra: (target: DatabaseColumn) => {
        type: "ColumnDrop";
        tableName: string;
        columnName: string;
        reason: Reason;
    }[];
    onCompare: (source: DatabaseColumn, target: DatabaseColumn) => SchemaDiff[];
};
