"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compareIndexes = void 0;
const helpers_1 = require("../helpers");
const types_1 = require("../types");
exports.compareIndexes = {
    getRenameKey: (index) => {
        if (index.override) {
            return index.override.value.sql.replace(index.name, 'INDEX_NAME');
        }
        return (0, helpers_1.asRenameKey)([index.tableName, ...(index.columnNames || []), index.unique]);
    },
    onRename: (source, target) => [
        {
            type: 'IndexRename',
            tableName: source.tableName,
            oldName: target.name,
            newName: source.name,
            reason: types_1.Reason.Rename,
        },
    ],
    onMissing: (source) => [
        {
            type: 'IndexCreate',
            index: source,
            reason: types_1.Reason.MissingInTarget,
        },
    ],
    onExtra: (target) => [
        {
            type: 'IndexDrop',
            indexName: target.name,
            reason: types_1.Reason.MissingInSource,
        },
    ],
    onCompare: (source, target) => {
        const sourceUsing = source.using ?? 'btree';
        const targetUsing = target.using ?? 'btree';
        let reason = '';
        if (!(0, helpers_1.haveEqualColumns)(source.columnNames, target.columnNames)) {
            reason = `columns are different (${source.columnNames} vs ${target.columnNames})`;
        }
        else if (source.unique !== target.unique) {
            reason = `uniqueness is different (${source.unique} vs ${target.unique})`;
        }
        else if (sourceUsing !== targetUsing) {
            reason = `using method is different (${source.using} vs ${target.using})`;
        }
        else if (source.where !== target.where) {
            reason = `where clause is different (${source.where} vs ${target.where})`;
        }
        else if (source.expression !== target.expression) {
            reason = `expression is different (${source.expression} vs ${target.expression})`;
        }
        if (reason) {
            return [
                { type: 'IndexDrop', indexName: target.name, reason },
                { type: 'IndexCreate', index: source, reason },
            ];
        }
        return [];
    },
};
//# sourceMappingURL=index.comparer.js.map