"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getUserAgentDetails = exports.fromMaybeArray = exports.fromChecksum = void 0;
const ua_parser_js_1 = require("ua-parser-js");
const fromChecksum = (checksum) => {
    return Buffer.from(checksum, checksum.length === 28 ? 'base64' : 'hex');
};
exports.fromChecksum = fromChecksum;
const fromMaybeArray = (param) => (Array.isArray(param) ? param[0] : param);
exports.fromMaybeArray = fromMaybeArray;
const getAppVersionFromUA = (ua) => ua.match(/^Immich_(?:Android|iOS)_(?<appVersion>.+)$/)?.groups?.appVersion ?? null;
const getUserAgentDetails = (headers) => {
    const userAgent = (0, ua_parser_js_1.UAParser)(headers['user-agent']);
    const appVersion = getAppVersionFromUA(headers['user-agent'] ?? '');
    return {
        deviceType: userAgent.browser.name || userAgent.device.type || headers['devicemodel'] || '',
        deviceOS: userAgent.os.name || headers['devicetype'] || '',
        appVersion,
    };
};
exports.getUserAgentDetails = getUserAgentDetails;
//# sourceMappingURL=request.js.map