import { CallContext } from './call-context.ts';
import { MemoryOptions } from './interfaces.ts';
export declare class HttpContext {
    fetch: typeof fetch;
    lastStatusCode: number;
    lastHeaders: Record<string, string> | null;
    allowedHosts: string[];
    memoryOptions: MemoryOptions;
    constructor(_fetch: typeof fetch, allowedHosts: string[], memoryOptions: MemoryOptions, allowResponseHeaders: boolean);
    contribute(functions: Record<string, Record<string, any>>): void;
    makeRequest(callContext: CallContext, reqaddr: bigint, bodyaddr: bigint): Promise<bigint>;
}
