"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
// See LICENSE in the project root for license information.
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardModifierTagSet = void 0;
const ModifierTagSet_1 = require("./ModifierTagSet");
const StandardTags_1 = require("./StandardTags");
/**
 * Extends the ModifierTagSet base class with getters for modifiers that
 * are part of the standardized core tags for TSDoc.
 */
class StandardModifierTagSet extends ModifierTagSet_1.ModifierTagSet {
    /**
     * Returns true if the `@alpha` modifier tag was specified.
     */
    isAlpha() {
        return this.hasTag(StandardTags_1.StandardTags.alpha);
    }
    /**
     * Returns true if the `@beta` modifier tag was specified.
     */
    isBeta() {
        return this.hasTag(StandardTags_1.StandardTags.beta);
    }
    /**
     * Returns true if the `@eventProperty` modifier tag was specified.
     */
    isEventProperty() {
        return this.hasTag(StandardTags_1.StandardTags.eventProperty);
    }
    /**
     * Returns true if the `@experimental` modifier tag was specified.
     */
    isExperimental() {
        return this.hasTag(StandardTags_1.StandardTags.experimental);
    }
    /**
     * Returns true if the `@internal` modifier tag was specified.
     */
    isInternal() {
        return this.hasTag(StandardTags_1.StandardTags.internal);
    }
    /**
     * Returns true if the `@override` modifier tag was specified.
     */
    isOverride() {
        return this.hasTag(StandardTags_1.StandardTags.override);
    }
    /**
     * Returns true if the `@packageDocumentation` modifier tag was specified.
     */
    isPackageDocumentation() {
        return this.hasTag(StandardTags_1.StandardTags.packageDocumentation);
    }
    /**
     * Returns true if the `@public` modifier tag was specified.
     */
    isPublic() {
        return this.hasTag(StandardTags_1.StandardTags.public);
    }
    /**
     * Returns true if the `@readonly` modifier tag was specified.
     */
    isReadonly() {
        return this.hasTag(StandardTags_1.StandardTags.readonly);
    }
    /**
     * Returns true if the `@sealed` modifier tag was specified.
     */
    isSealed() {
        return this.hasTag(StandardTags_1.StandardTags.sealed);
    }
    /**
     * Returns true if the `@virtual` modifier tag was specified.
     */
    isVirtual() {
        return this.hasTag(StandardTags_1.StandardTags.virtual);
    }
}
exports.StandardModifierTagSet = StandardModifierTagSet;
//# sourceMappingURL=StandardModifierTagSet.js.map