"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.filterInPlace = filterInPlace;
exports.count = count;
/**
 * Remove all elements from the given array that return false from the given
 * predicate `filter`.
 */
function filterInPlace(arr, filter) {
    const len = arr.length;
    let j = 0;
    // PERF: for-loop to avoid the additional closure from a forEach
    for (let i = 0; i < len; i++) {
        const ea = arr[i];
        if (filter(ea)) {
            if (i !== j)
                arr[j] = ea;
            j++;
        }
    }
    arr.length = j;
    return arr;
}
function count(arr, predicate) {
    let acc = 0;
    for (let idx = 0; idx < arr.length; idx++) {
        if (predicate(arr[idx], idx))
            acc++;
    }
    return acc;
}
//# sourceMappingURL=Array.js.map