import { InternalBatchProcessOptions } from "./InternalBatchProcessOptions";
import { HealthCheckable } from "./ProcessHealthMonitor";
import { WhyNotHealthy } from "./WhyNotHealthy";
/**
 * Strategy interface for different health check approaches
 */
export interface HealthCheckStrategy {
    assess(process: HealthCheckable, options: InternalBatchProcessOptions): WhyNotHealthy | null;
}
/**
 * Checks if process has ended or is ending
 */
export declare class LifecycleHealthCheck implements HealthCheckStrategy {
    assess(process: HealthCheckable): WhyNotHealthy | null;
}
/**
 * Checks if process stdin is available
 */
export declare class StreamHealthCheck implements HealthCheckStrategy {
    assess(process: HealthCheckable): WhyNotHealthy | null;
}
/**
 * Checks if process has exceeded task limits
 */
export declare class TaskLimitHealthCheck implements HealthCheckStrategy {
    assess(process: HealthCheckable, options: InternalBatchProcessOptions): WhyNotHealthy | null;
}
/**
 * Checks if process has been idle too long
 */
export declare class IdleTimeHealthCheck implements HealthCheckStrategy {
    assess(process: HealthCheckable, options: InternalBatchProcessOptions): WhyNotHealthy | null;
}
/**
 * Checks if process has too many failed tasks
 */
export declare class FailureCountHealthCheck implements HealthCheckStrategy {
    assess(process: HealthCheckable, options: InternalBatchProcessOptions): WhyNotHealthy | null;
}
/**
 * Checks if process is too old
 */
export declare class AgeHealthCheck implements HealthCheckStrategy {
    assess(process: HealthCheckable, options: InternalBatchProcessOptions): WhyNotHealthy | null;
}
/**
 * Checks if current task has timed out
 */
export declare class TaskTimeoutHealthCheck implements HealthCheckStrategy {
    assess(process: HealthCheckable, options: InternalBatchProcessOptions): WhyNotHealthy | null;
}
/**
 * Composite strategy that runs all health checks in order of priority
 */
export declare class CompositeHealthCheckStrategy implements HealthCheckStrategy {
    private readonly strategies;
    assess(process: HealthCheckable, options: InternalBatchProcessOptions): WhyNotHealthy | null;
}
