/**
 * Wrapper for sandboxing.
 *
 */
import { ChildProcessor } from './child-processor';
import { ParentCommand, ChildCommand } from '../enums';
import { errorToJSON, toString } from '../utils';
export default (send, receiver) => {
    const childProcessor = new ChildProcessor(send, receiver);
    receiver === null || receiver === void 0 ? void 0 : receiver.on('message', async (msg) => {
        try {
            switch (msg.cmd) {
                case ChildCommand.Init:
                    await childProcessor.init(msg.value);
                    break;
                case ChildCommand.Start:
                    await childProcessor.start(msg.job, msg === null || msg === void 0 ? void 0 : msg.token);
                    break;
                case ChildCommand.Stop:
                    break;
            }
        }
        catch (err) {
            console.error('Error handling child message');
        }
    });
    process.on('SIGTERM', () => childProcessor.waitForCurrentJobAndExit());
    process.on('SIGINT', () => childProcessor.waitForCurrentJobAndExit());
    process.on('uncaughtException', async (err) => {
        if (typeof err !== 'object') {
            err = new Error(toString(err));
        }
        await send({
            cmd: ParentCommand.Failed,
            value: errorToJSON(err),
        });
        // An uncaughException leaves this process in a potentially undetermined state so
        // we must exit
        process.exit();
    });
};
//# sourceMappingURL=main-base.js.map