"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BinaryField = void 0;
const Number_1 = require("./Number");
// "(Binary data 2506078 bytes, use -b option to extract)"
const BinaryFieldRE = 
// 1000000000 bytes is 1 GB. The largest binary field I've seen is ~5 MB (7
// chars): 10 chars is absurdly large, and is just to avoid the
// `js/polynomial-redos` eslint rule.
/Binary(?: data)? (\d{1,10}) bytes/i;
/**
 * Represents a binary field in the Exif data.
 *
 * These fields can be used to store images (including thumbnails and full-sized
 * images), audio, and other binary data. The size of the field is specified in
 * bytes.
 */
class BinaryField {
    bytes;
    rawValue;
    constructor(bytes, rawValue) {
        this.bytes = bytes;
        this.rawValue = rawValue;
    }
    toJSON() {
        return {
            _ctor: "BinaryField",
            bytes: this.bytes,
            rawValue: this.rawValue,
        };
    }
    static fromJSON(json) {
        return new BinaryField(json.bytes, json.rawValue);
    }
    static fromRawValue(rawValue) {
        const m = rawValue.match(BinaryFieldRE);
        if (m != null) {
            const bytes = (0, Number_1.toInt)(m[1]);
            if (bytes != null) {
                return new BinaryField(bytes, rawValue);
            }
        }
        return;
    }
}
exports.BinaryField = BinaryField;
//# sourceMappingURL=BinaryField.js.map