import { ExifToolTask } from "./ExifToolTask";
import { Maybe } from "./Maybe";
import { Tags } from "./Tags";
export declare const ReadTaskOptionFields: ["adjustTimeZoneIfDaylightSavings", "backfillTimezones", "defaultVideosToUTC", "geolocation", "geoTz", "ignoreMinorErrors", "ignoreZeroZeroLatLon", "imageHashType", "includeImageDataMD5", "inferTimezoneFromDatestamps", "inferTimezoneFromDatestampTags", "inferTimezoneFromTimeStamp", "keepUTCTime", "numericTags", "preferTimezoneInferenceFromGps", "readArgs", "struct", "useMWG"];
export declare function nullish(s: unknown): s is undefined;
export declare const DefaultReadTaskOptions: {
    readonly includeImageDataMD5: boolean | undefined;
    readonly imageHashType: false | "MD5" | "SHA256" | "SHA512";
    readonly useMWG: boolean;
    readonly numericTags: string[];
    readonly defaultVideosToUTC: boolean;
    readonly backfillTimezones: boolean;
    readonly inferTimezoneFromDatestamps: boolean;
    readonly inferTimezoneFromDatestampTags: (keyof Tags)[];
    readonly inferTimezoneFromTimeStamp: boolean;
    readonly ignoreZeroZeroLatLon: boolean;
    readonly geoTz: typeof import("./GeoTz").geoTz;
    readonly geolocation: boolean;
    readonly ignoreMinorErrors: boolean;
    readonly struct: "undef" | 0 | 1 | 2;
    readonly readArgs: string[];
    readonly adjustTimeZoneIfDaylightSavings: (tags: Tags, tz: string) => Maybe<number>;
    readonly preferTimezoneInferenceFromGps: boolean;
    readonly keepUTCTime: boolean;
};
export type ReadTaskOptions = Partial<typeof DefaultReadTaskOptions>;
export declare class ReadTask extends ExifToolTask<Tags> {
    #private;
    readonly sourceFile: string;
    readonly args: string[];
    options: Required<ReadTaskOptions>;
    private readonly degroup;
    /**
     * @param sourceFile the file to read
     * @param args the full arguments to pass to exiftool that take into account
     * the flags in `options`
     * @param options the required options for reading metadata
     */
    constructor(sourceFile: string, args: string[], options: Required<ReadTaskOptions>);
    static for(filename: string, options: ReadTaskOptions): ReadTask;
    toString(): string;
    parse(data: string, err?: Error): Tags;
}
