"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.RewriteAllTagsTask = void 0;
const _path = __importStar(require("node:path"));
const Array_1 = require("./Array");
const ExifToolTask_1 = require("./ExifToolTask");
const FilenameCharsetArgs_1 = require("./FilenameCharsetArgs");
/**
 * Task for rewriting all metadata tags in a file, which can repair corrupted metadata.
 */
class RewriteAllTagsTask extends ExifToolTask_1.ExifToolTask {
    constructor(args, options) {
        super(args, options);
    }
    /**
     * Creates a task to rewrite all metadata tags from source to destination.
     * @param imgSrc the source image file path
     * @param imgDest the destination file path
     * @param opts options including allowMakerNoteRepair for fixing corrupted MakerNote data
     * @returns a new RewriteAllTagsTask instance
     */
    static for(imgSrc, imgDest, opts) {
        // -all= -tagsfromfile @ -all:all -unsafe -icc_profile bad.jpg
        const args = (0, Array_1.compact)([
            ...FilenameCharsetArgs_1.Utf8FilenameCharsetArgs,
            "-all=",
            "-tagsfromfile",
            "@",
            "-all:all",
            "-unsafe",
            "-icc_profile",
            opts.allowMakerNoteRepair ? "-F" : undefined,
            "-out",
            _path.resolve(imgDest),
            _path.resolve(imgSrc),
        ]);
        return new RewriteAllTagsTask(args, opts);
    }
    parse(data, error) {
        if (error != null) {
            const str = String(error);
            // Ignore warnings:
            if (str.match(/\berror\b/i) != null && !str.match(/\bwarning\b/i)) {
                throw error;
            }
        }
        if (null == data.match(/^\s*1 image files creat/i)) {
            throw (error ??
                new Error(data.trim().split("\n")[0] ?? "Missing expected status message"));
        }
    }
}
exports.RewriteAllTagsTask = RewriteAllTagsTask;
//# sourceMappingURL=RewriteAllTagsTask.js.map