import { Maybe } from "./Maybe";
export declare function isString(o: unknown): o is string;
export declare function blank(s: unknown): s is undefined;
export declare function notBlank(s: unknown): s is string;
/**
 * @returns true iff `s` is a string with at least one non-whitespace character.
 */
export declare function notBlankString(s: unknown): s is string;
export declare function toNotBlank(s: Maybe<string>): Maybe<string>;
export declare function compactBlanks(arr: Maybe<string>[]): string[];
export declare function toS(s: Maybe<unknown>): string;
export declare function leftPad(i: Maybe<number | string>, minLen: number, padChar: "0" | " "): string;
export declare function pad2(...numbers: number[]): string[];
export declare function pad3(...numbers: number[]): string[];
/**
 * NOT FOR GENERAL USE, as this is latin-case-insensitive
 */
export declare function stripPrefix(s: string, prefix: string): string;
export declare function stripSuffix(s: string, suffix: string): string;
/**
 * @returns `arr` with all empty strings removed and all non-empty strings trimmed.
 */
export declare function splitLines(...arr: string[]): string[];
