"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagNames = exports.XMPTagsNames = exports.MakerNotesTagsNames = exports.JFIFTagsNames = exports.RIFFTagsNames = exports.RAFTagsNames = exports.QuickTimeTagsNames = exports.IPTCTagsNames = exports.PrintIMTagsNames = exports.PhotoshopTagsNames = exports.PanasonicRawTagsNames = exports.MetaTagsNames = exports.MPFTagsNames = exports.JUMBFTagsNames = exports.JSONTagsNames = exports.JPEGTagsNames = exports.EXIFTagsNames = exports.FlashPixTagsNames = exports.DuckyTagsNames = exports.APPTagsNames = exports.CompositeTagsNames = exports.FileTagsNames = exports.ExifToolTagsNames = void 0;
const ExifToolVendoredTags_1 = require("./ExifToolVendoredTags");
const GeolocationTags_1 = require("./GeolocationTags");
const ICCProfileTags_1 = require("./ICCProfileTags");
const ImageDataHashTag_1 = require("./ImageDataHashTag");
const IPTCApplicationRecordTags_1 = require("./IPTCApplicationRecordTags");
const MWGTags_1 = require("./MWGTags");
const StrEnum_1 = require("./StrEnum");
exports.ExifToolTagsNames = (0, StrEnum_1.strEnum)("Error", "ExifToolVersion", "SourceFile", "Warning");
exports.FileTagsNames = (0, StrEnum_1.strEnum)("BitDepth", "BitsPerSample", "BMPVersion", "ColorComponents", "Comment", "Compression", "CurrentIPTCDigest", "Directory", "EncodingProcess", "ExifByteOrder", "FileAccessDate", "FileCreateDate", "FileInodeChangeDate", "FileModifyDate", "FileName", "FilePermissions", "FileSize", "FileType", "FileTypeExtension", "ImageDataMD5", "ImageHeight", "ImageLength", "ImageWidth", "MakerNoteByteOrder", "MIMEType", "NumColors", "NumImportantColors", "PixelsPerMeterX", "PixelsPerMeterY", "Planes", "PreviewImage", "YCbCrSubSampling");
exports.CompositeTagsNames = (0, StrEnum_1.strEnum)("AdvancedSceneMode", "Aperture", "AutoFocus", "AvgBitrate", "BlueBalance", "CFAPattern", "CircleOfConfusion", "ConditionalFEC", "ContrastDetectAF", "Copyright", "Country", "CreateDate", "Creator", "DateCreated", "DateTimeCreated", "DateTimeOriginal", "Description", "DigitalCreationDateTime", "DigitalZoom", "DOF", "DriveMode", "Duration", "ExtenderStatus", "FileNumber", "Flash", "FlashType", "FocalLength35efl", "FocusDistance", "FOV", "GPSAltitude", "GPSAltitudeRef", "GPSDateTime", "GPSDestLatitude", "GPSDestLongitude", "GPSLatitude", "GPSLatitudeRef", "GPSLongitude", "GPSLongitudeRef", "GPSPosition", "HyperfocalDistance", "ImageHeight", "ImageSize", "ImageWidth", "ISO", "Keywords", "Lens", "Lens35efl", "LensID", "LensSpec", "LensType", "LightValue", "Megapixels", "ModifyDate", "Orientation", "OriginalDecisionData", "PeakSpectralSensitivity", "PhaseDetectAF", "PreviewImage", "PreviewImageSize", "Rating", "RedBalance", "RedEyeReduction", "RicohPitch", "RicohRoll", "Rotation", "RunTimeSincePowerUp", "ScaleFactor35efl", "ShootingMode", "ShutterCurtainHack", "ShutterSpeed", "State", "SubSecCreateDate", "SubSecDateTimeOriginal", "SubSecModifyDate");
exports.APPTagsNames = (0, StrEnum_1.strEnum)("AboveColor", "Again", "AmbientTemperature", "Aperture", "AtmosphericTemperature", "AutoISOMax", "AutoISOMin", "AutoRotation", "B5100", "Balance", "Barcode", "BelowColor", "Bgain", "BHighLight", "BHL", "BitsPerSample", "Blk0", "Blk1", "BMean", "Boff", "BSD", "BSd", "BStrobe", "CameraModel", "CameraPartNumber", "CameraSerialNumber", "CameraSoftware", "CameraType", "Case", "CBal", "Color", "COLOR1", "COLOR2", "COLOR3", "COLOR4", "ColorComponents", "ColorMode", "ColorSpace", "ColorTransform", "Compass", "Compression", "ContTake", "CreatorSoftware", "DateTimeGenerated", "DateTimeOriginal", "DCTEncodeVersion", "DeviceName", "DiagonalFieldOfView", "DigitalZoom", "DigitalZoomOn", "EmbeddedImage", "EmbeddedImageHeight", "EmbeddedImageType", "EmbeddedImageWidth", "Emissivity", "EXP1", "EXP2", "EXP3", "ExposRatio", "Exposure", "ExposureCompensation", "ExposureTime", "ExposureType", "FieldOfView", "FilterModel", "FilterPartNumber", "FilterSerialNumber", "FinalRatio", "FirmwareVersion", "Flash", "FlashTime", "FMean", "FNumber", "Fnumber", "FocusDistance", "FocusMode", "FocusPos", "FocusStepCount", "FrameRate", "Gain", "Gamma", "GBgain", "GBoff", "GHighLight", "GHL", "GMean", "GPSAltitude", "GPSDOP", "GPSImgDirection", "GPSImgDirectionRef", "GPSLatitude", "GPSLatitudeRef", "GPSLongitude", "GPSLongitudeRef", "GPSMapDatum", "GPSSpeed", "GPSSpeedRef", "GPSTrack", "GPSTrackRef", "GPSValid", "GPSVersionID", "GRgain", "GRoff", "GSD", "GSd", "HDRGainCurve", "HDRGainCurveSize", "HDRSetting", "ID", "ImageHeight", "ImageSize", "ImageWidth", "IRWindowTemperature", "IRWindowTransmission", "Isotherm1Color", "Isotherm2Color", "JPEG1", "LensModel", "LensPartNumber", "LensProjection", "LensSerialNumber", "LightS", "Macro", "Mean", "Meas1Label", "Meas1Params", "Meas1Type", "Meas2Label", "Meas2Params", "Meas2Type", "MediaUniqueID", "MetadataVersion", "Model", "MotorPos", "ObjectDistance", "Offset", "OffsetX", "OffsetY", "OverflowColor", "Palette", "PaletteColors", "PaletteFileName", "PaletteMethod", "PaletteName", "PaletteStretch", "Param0", "PhotoResolution", "PicLen", "PreviewImageHeight", "PreviewImageWidth", "PreviewQuality", "Protect", "Protune", "Quality", "R5100", "Rate", "RawThermalImage", "RawThermalImageHeight", "RawThermalImageType", "RawThermalImageWidth", "RawValueMedian", "RawValueRange", "RawValueRangeMax", "RawValueRangeMin", "Real2IR", "ReflectedApparentTemperature", "RelativeHumidity", "Resolution", "ResolutionUnit", "REV", "Rgain", "RHighLight", "RHL", "RMean", "Roff", "RSD", "RSd", "RStrobe", "S0", "SerialNumber", "Sharpness", "SpotMeter", "StrobeTime", "T0", "TagB", "TagQ", "TagR", "TagS", "ThmLen", "UnderflowColor", "Version", "WhiteBalance", "XResolution", "YLevel", "YResolution", "YTarget", "Zoom", "ZoomPos");
exports.DuckyTagsNames = (0, StrEnum_1.strEnum)("Quality");
exports.FlashPixTagsNames = (0, StrEnum_1.strEnum)("AudioStream", "CodePage", "CreatingApplication", "ExtensionClassID", "ExtensionCreateDate", "ExtensionDescription", "ExtensionModifyDate", "ExtensionName", "ExtensionPersistence", "PreviewImage", "PreviewImageHeight", "PreviewImageWidth", "ScreenNail", "UsedExtensionNumbers");
exports.EXIFTagsNames = (0, StrEnum_1.strEnum)("Acceleration", "ActiveArea", "AmbientTemperature", "AnalogBalance", "AntiAliasStrength", "ApertureValue", "Artist", "AsShotNeutral", "AsShotWhiteXY", "BaselineExposure", "BaselineNoise", "BaselineSharpness", "BayerGreenSplit", "BestQualityScale", "BitsPerSample", "BlackLevel", "BlackLevelBlue", "BlackLevelGreen", "BlackLevelRed", "BlackLevelRepeatDim", "BrightnessValue", "CameraElevationAngle", "CameraSerialNumber", "CFALayout", "CFAPattern", "CFAPlaneColor", "CFARepeatPatternDim", "ChromaticAberrationCorrection", "ChromaticAberrationCorrParams", "ColorSpace", "CompositeImage", "CompositeImageCount", "CompositeImageExposureTimes", "CompressedBitsPerPixel", "Compression", "Contrast", "Copyright", "CreateDate", "CropBottom", "CropLeft", "CropRight", "CropTop", "CustomRendered", "DateTimeOriginal", "DefaultBlackRender", "DefaultCropOrigin", "DefaultCropSize", "DefaultScale", "DefaultUserCrop", "DeviceSettingDescription", "DigitalZoomRatio", "DistortionCorrection", "DistortionCorrParams", "DNGBackwardVersion", "DNGVersion", "DocumentName", "ExifImageHeight", "ExifImageWidth", "ExifVersion", "ExposureCompensation", "ExposureIndex", "ExposureMode", "ExposureProgram", "ExposureTime", "FileSource", "Flash", "FlashEnergy", "FNumber", "FocalLength", "FocalLengthIn35mmFormat", "FocalPlaneResolutionUnit", "FocalPlaneXResolution", "FocalPlaneYResolution", "GainControl", "Gamma", "GPSAltitude", "GPSAltitudeRef", "GPSAreaInformation", "GPSDateStamp", "GPSDestBearing", "GPSDestBearingRef", "GPSDestDistance", "GPSDestDistanceRef", "GPSDestLatitude", "GPSDestLatitudeRef", "GPSDestLongitude", "GPSDestLongitudeRef", "GPSDifferential", "GPSDOP", "GPSHPositioningError", "GPSImgDirection", "GPSImgDirectionRef", "GPSLatitude", "GPSLatitudeRef", "GPSLongitude", "GPSLongitudeRef", "GPSMapDatum", "GPSMeasureMode", "GPSPosition", "GPSProcessingMethod", "GPSSatellites", "GPSSpeed", "GPSSpeedRef", "GPSStatus", "GPSTimeStamp", "GPSTrack", "GPSTrackRef", "GPSVersionID", "HighISOMultiplierBlue", "HighISOMultiplierGreen", "HighISOMultiplierRed", "HostComputer", "ImageDescription", "ImageHeight", "ImageNumber", "ImageTitle", "ImageUniqueID", "ImageWidth", "InteropIndex", "InteropVersion", "ISO", "ISOSpeed", "JpgFromRaw", "JpgFromRawLength", "JpgFromRawStart", "LensInfo", "LensMake", "LensModel", "LensSerialNumber", "LightSource", "LinearityLimitBlue", "LinearityLimitGreen", "LinearityLimitRed", "LinearizationTable", "LinearResponseLimit", "Make", "MakerNoteSafety", "MakerNoteSamsung1a", "MakerNoteUnknownBinary", "MakerNoteUnknownText", "MaxApertureValue", "MeteringMode", "Model", "Model2", "ModifyDate", "NewRawImageDigest", "Noise", "NoiseProfile", "NoiseReductionApplied", "NoiseReductionParams", "OffsetSchema", "OffsetTime", "OffsetTimeDigitized", "OffsetTimeOriginal", "Orientation", "OtherImage", "OtherImageLength", "OtherImageStart", "OwnerName", "Padding", "PageName", "PanasonicRawVersion", "Photographer", "PhotometricInterpretation", "PlanarConfiguration", "Pressure", "PreviewColorSpace", "PreviewDateTime", "PreviewImage", "PreviewImageLength", "PreviewImageStart", "PreviewTIFF", "PrimaryChromaticities", "ProcessingSoftware", "ProfileEmbedPolicy", "ProfileGainTableMap", "ProfileName", "ProfileToneCurve", "Rating", "RatingPercent", "RawDataOffset", "RawDataUniqueID", "RawFormat", "RawImageSegmentation", "RecommendedExposureIndex", "ReferenceBlackWhite", "RelatedImageFileFormat", "RelatedImageHeight", "RelatedImageWidth", "RelatedSoundFile", "ResolutionUnit", "RowsPerStrip", "SamplesPerPixel", "Saturation", "SceneCaptureType", "SceneType", "SemanticName", "SensingMethod", "SensitivityType", "SensorBottomBorder", "SensorHeight", "SensorLeftBorder", "SensorRightBorder", "SensorTopBorder", "SensorWidth", "SerialNumber", "ShadowScale", "Sharpness", "ShutterSpeedValue", "Software", "SonyCropSize", "SonyCropTopLeft", "SonyRawFileType", "SonyRawImageSize", "SonyToneCurve", "SpatialFrequencyResponse", "SRawType", "StandardOutputSensitivity", "StripByteCounts", "StripOffsets", "SubfileType", "SubjectArea", "SubjectDistance", "SubjectDistanceRange", "SubjectLocation", "SubSecTime", "SubSecTimeDigitized", "SubSecTimeOriginal", "ThumbnailImage", "ThumbnailLength", "ThumbnailOffset", "ThumbnailTIFF", "TileByteCounts", "TileLength", "TileOffsets", "TileWidth", "TimeZoneOffset", "TransferFunction", "UniqueCameraModel", "UserComment", "VignettingCorrection", "VignettingCorrParams", "WaterDepth", "WBBlueLevel", "WBGreenLevel", "WBRedLevel", "WhiteBalance", "WhiteLevel", "WhitePoint", "XiaomiModel", "XPAuthor", "XPComment", "XPKeywords", "XPSubject", "XPTitle", "XResolution", "YCbCrCoefficients", "YCbCrPositioning", "YCbCrSubSampling", "YResolution");
exports.JPEGTagsNames = (0, StrEnum_1.strEnum)("UniformResourceName");
exports.JSONTagsNames = (0, StrEnum_1.strEnum)("AIScene", "FilterId", "Hdr", "Mirror", "OpMode", "SensorType", "ZoomMultiple");
exports.JUMBFTagsNames = (0, StrEnum_1.strEnum)("Actions", "Alg", "Exclusions", "Hash", "InstanceID", "Item0", "Item1", "Item3", "JUMDLabel", "JUMDType", "Pad", "Pad2", "Parts", "Signature");
exports.MPFTagsNames = (0, StrEnum_1.strEnum)("DependentImage1EntryNumber", "DependentImage2EntryNumber", "ImageUIDList", "MPFVersion", "MPImageFlags", "MPImageFormat", "MPImageLength", "MPImageStart", "MPImageType", "NumberOfImages", "PreviewImage", "TotalFrames");
exports.MetaTagsNames = (0, StrEnum_1.strEnum)("BorderID", "BorderLocation", "BorderName", "BordersVersion", "BorderType", "CameraOwner", "CaptureConditionsPAR", "DigitalEffectsName", "DigitalEffectsType", "DigitalEffectsVersion", "EditTagArray", "FilmGencode", "FilmProductCode", "FilmSize", "FrameNumber", "ImageSourceEK", "MetadataNumber", "ModelAndVersion", "SerialNumber", "WatermarkType");
exports.PanasonicRawTagsNames = (0, StrEnum_1.strEnum)("ApertureValue", "DistortionCorrection", "DistortionScale", "FlashFired", "FocalLengthIn35mmFormat", "FocusStepCount", "FocusStepNear", "LensTypeMake", "LensTypeModel", "NumWBEntries", "Orientation", "ShutterSpeedValue", "WhiteBalanceSet");
exports.PhotoshopTagsNames = (0, StrEnum_1.strEnum)("CopyrightFlag", "DisplayedUnitsX", "DisplayedUnitsY", "GlobalAltitude", "GlobalAngle", "HasRealMergedData", "IPTCDigest", "NumSlices", "PhotoshopFormat", "PhotoshopQuality", "PhotoshopThumbnail", "PixelAspectRatio", "PrintPosition", "PrintScale", "PrintStyle", "ReaderName", "SlicesGroupName", "WriterName", "XResolution", "YResolution");
exports.PrintIMTagsNames = (0, StrEnum_1.strEnum)("PrintIMVersion");
exports.IPTCTagsNames = (0, StrEnum_1.strEnum)("CodedCharacterSet", "DateCreated", "DigitalCreationDate", "DigitalCreationTime", "EnvelopeRecordVersion", "Keywords", "TimeCreated");
exports.QuickTimeTagsNames = (0, StrEnum_1.strEnum)("AndroidCaptureFPS", "AndroidVersion", "AndroidVideoTemporalLayersCount", "AudioBitsPerSample", "AudioChannels", "AudioFormat", "AudioSampleRate", "AudioVendorID", "Author", "BackgroundColor", "Balance", "BitDepth", "ChapterListTrackID", "CleanApertureDimensions", "ColorPrimaries", "ColorProfiles", "CompatibleBrands", "CompressorID", "CompressorName", "CompressorVersion", "ContentDescribes", "ContentIdentifier", "CreateDate", "CreationDate", "CurrentTime", "Duration", "EncodedPixelsDimensions", "FirmwareVersion", "FocalLengthIn35mmFormat", "FontName", "Format", "Gamma", "GenBalance", "GenFlags", "GenGraphicsMode", "GenMediaVersion", "GenOpColor", "GPSCoordinates", "GraphicsMode", "HandlerClass", "HandlerDescription", "HandlerType", "HandlerVendorID", "ImageHeight", "ImageWidth", "JpgFromRaw", "LayoutFlags", "LensModel", "LensSerialNumber", "LocationAccuracyHorizontal", "MajorBrand", "Make", "MatrixCoefficients", "MatrixStructure", "MediaCreateDate", "MediaDataOffset", "MediaDataSize", "MediaDuration", "MediaHeaderVersion", "MediaLanguageCode", "MediaModifyDate", "MediaTimeScale", "MediaUID", "MetaFormat", "MinorVersion", "Model", "ModifyDate", "MovieHeaderVersion", "NextTrackID", "OpColor", "OtherFormat", "PixelAspectRatio", "PlaybackFrameRate", "PlayMode", "PosterTime", "PreferredRate", "PreferredVolume", "PreviewDuration", "PreviewImage", "PreviewTime", "ProductionApertureDimensions", "PurchaseFileFormat", "SampleDuration", "SampleTime", "SelectionDuration", "SelectionTime", "SerialNumberHash", "Software", "SourceImageHeight", "SourceImageWidth", "TextColor", "TextFace", "TextFont", "TextSize", "TimecodeTrack", "TimeScale", "TrackCreateDate", "TrackDuration", "TrackHeaderVersion", "TrackID", "TrackLayer", "TrackModifyDate", "TrackVolume", "TransferCharacteristics", "VendorID", "VideoFrameRate", "VideoFullRangeFlag", "XResolution", "YResolution");
exports.RAFTagsNames = (0, StrEnum_1.strEnum)("BitsPerSample", "BlackLevel", "ChromaticAberrationParams", "FujiLayout", "GeometricDistortionParams", "RAFCompression", "RawExposureBias", "RawImageAspectRatio", "RawImageCroppedSize", "RawImageCropTopLeft", "RawImageFullHeight", "RawImageFullSize", "RawImageFullWidth", "RawZoomActive", "RawZoomSize", "RawZoomTopLeft", "StripByteCounts", "StripOffsets", "VignettingParams", "XTransLayout");
exports.RIFFTagsNames = (0, StrEnum_1.strEnum)("AudioCodec", "AudioSampleCount", "AudioSampleRate", "AvgBytesPerSec", "BitsPerSample", "DateTimeOriginal", "Encoding", "FrameCount", "FrameRate", "ImageHeight", "ImageWidth", "MaxDataRate", "NumChannels", "Quality", "SampleRate", "SampleSize", "Software", "StreamCount", "StreamType", "VideoCodec", "VideoFrameCount", "VideoFrameRate");
exports.JFIFTagsNames = (0, StrEnum_1.strEnum)("JFIFVersion", "ResolutionUnit", "ThumbnailHeight", "ThumbnailImage", "ThumbnailTIFF", "ThumbnailWidth", "XResolution", "YResolution");
exports.MakerNotesTagsNames = (0, StrEnum_1.strEnum)("AccelerationTracking", "AccelerationVector", "Accelerometer", "AccelerometerX", "AccelerometerY", "AccelerometerZ", "AccessorySerialNumber", "AccessoryType", "ActionInAFCCont", "ActionPriority", "ActualCompensation", "AddAspectRatioInfo", "AddIPTCInformation", "AddOriginalDecisionData", "ADJDebugInfo", "AdjustmentMode", "ADLBracketingStep", "ADLBracketingType", "AdvancedFilter", "AdvancedSceneType", "AEAperture", "AEApertureSteps", "AEAverage", "AEBAutoCancel", "AEBBracketValue", "AEBracketingSteps", "AEBSequence", "AEBSequenceAutoCancel", "AEBShotCount", "AEBXv", "AEDebugInfo", "AEExposureTime", "AEHistogramInfo", "AELButton", "AELExposureIndicator", "AELiveViewHistogramInfo", "AELiveViewLocalHistogram", "AELocalHistogram", "AELock", "AELockButton", "AELockButtonPlusDials", "AELockMeterModeAfterFocus", "AEMaxAperture", "AEMeteringMode", "AEMeteringSegments", "AEMicroadjustment", "AEMinAperture", "AEMinExposureTime", "AEProgramMode", "AESetting", "AEStable", "AETarget", "AEWhiteBalance", "AEXv", "AFAccelDecelTracking", "AFActivation", "AFAdjustment", "AFAndMeteringButtons", "AFAperture", "AFAreaHeight", "AFAreaHeights", "AFAreaIllumination", "AFAreaMode", "AFAreaModeSetting", "AFAreaPointSize", "AFAreas", "AFAreaSelectionMethod", "AFAreaSelectMethod", "AFAreaSize", "AFAreaWidth", "AFAreaWidths", "AFAreaXPosition", "AFAreaXPositions", "AFAreaYPosition", "AFAreaYPositions", "AFAreaZoneSize", "AFAssist", "AFAssistBeam", "AFAssistLamp", "AFButtonPressed", "AFCHold", "AFConfidence", "AFConfigTool", "AFCoordinatesAvailable", "AFCPointTracking", "AFCSensitivity", "AFDebugInfo", "AFDefocus", "AFDetectionMethod", "AFDuringLiveView", "AFFineTune", "AFFineTuneAdj", "AFFineTuneAdjTele", "AFFineTuneIndex", "AFFocusArea", "AFFrameSize", "AFIlluminator", "AFImageHeight", "AFImageWidth", "AFInfo2Version", "AFIntegrationTime", "AFMeasuredDepth", "AFMicroAdj", "AFMicroAdjMode", "AFMicroAdjRegisteredLenses", "AFMicroadjustment", "AFMicroAdjValue", "AFMode", "AFModeRestrictions", "AFOnAELockButtonSwitch", "AFOnButton", "AFPerformance", "AFPoint", "AFPointActivationArea", "AFPointAreaExpansion", "AFPointAtShutterRelease", "AFPointAutoSelection", "AFPointBrightness", "AFPointDetails", "AFPointDisplayDuringFocus", "AFPointIllumination", "AFPointInFocus", "AFPointMode", "AFPointPosition", "AFPointRegistration", "AFPoints", "AFPointSel", "AFPointSelected", "AFPointSelection", "AFPointSelectionMethod", "AFPointSetting", "AFPointsInFocus", "AFPointsInFocus1D", "AFPointsInFocus5D", "AFPointSpotMetering", "AFPointsSelected", "AFPointsSpecial", "AFPointsUsed", "AFPointSwitching", "AFPredictor", "AFTracking", "AFTrackingSensitivity", "AFType", "AFWithShutter", "AIServoContinuousShooting", "AIServoFirstImage", "AIServoFirstImagePriority", "AIServoImagePriority", "AIServoSecondImage", "AIServoSecondImagePriority", "AIServoTrackingMethod", "AIServoTrackingSensitivity", "AISubjectTrackingMode", "Altitude", "AmbienceSelection", "AmbientTemperature", "AmbientTemperatureFahrenheit", "AndroidRelease", "AntiFlicker", "AntiShockWaitingTime", "Aperture", "ApertureLock", "ApertureRange", "ApertureRingUse", "ApertureSetting", "ApertureValue", "Application", "ApplySettingsToLiveView", "ApplyShootingMeteringMode", "ApproximateFNumber", "AppVersion", "ArtFilter", "ArtFilterEffect", "Artist", "ArtMode", "ArtModeParameters", "AspectFrame", "AspectRatio", "AssignBktButton", "AssignFuncButton", "AssignMovieFunc1ButtonPlusDials", "AssignMovieFunc2Button", "AssignMoviePreviewButtonPlusDials", "AssignMovieRecordButton", "AssignMovieRecordButtonPlusDials", "AssignMovieSubselector", "AssignMovieSubselectorPlusDials", "AssignRemoteFnButton", "AssistButtonFunction", "Audio", "AudioCompression", "AutoAFPointColorTracking", "AutoAFPointSelEOSiTRAF", "AutoAperture", "AutoBracket", "AutoBracketing", "AutoBracketingMode", "AutoBracketingSet", "AutoBracketModeM", "AutoBracketOrder", "AutoBracketSet", "AutoDistortionControl", "AutoDynamicRange", "AutoExposureBracketing", "AutoFlashISOSensitivity", "AutoFocusModeRestrictions", "AutoFP", "AutoISO", "AutoISOMax", "AutoISOMinShutterSpeed", "AutoLightingOptimizer", "AutoPortraitFramed", "AutoRotate", "AuxiliaryLens", "AvApertureSetting", "AverageBlackLevel", "AverageLV", "AvSettingWithoutLens", "BabyAge", "BabyName", "Barcode", "BarometerInfoVersion", "BaseExposureCompensation", "BaseISO", "BatteryLevel", "BatteryOrder", "BatteryState", "BatteryTemperature", "BatteryType", "BatteryVoltage", "BayerPattern", "Beep", "BeepPitch", "BeepVolume", "BestShotMode", "BitDepth", "BlackLevel", "BlackLevels", "BlackMaskBottomBorder", "BlackMaskLeftBorder", "BlackMaskRightBorder", "BlackMaskTopBorder", "BlackPoint", "BleachBypassToning", "BlueBalance", "BlueGain", "BlurControl", "BlurWarning", "BoardTemperature", "BodyBatteryADLoad", "BodyBatteryADNoLoad", "BodyBatteryPercent", "BodyBatteryState", "BodyBatteryVoltage", "BodyFirmware", "BodyFirmwareVersion", "BodySerialNumber", "BracketIncrement", "BracketingBurstOptions", "BracketMode", "BracketProgram", "BracketSequence", "BracketSet", "BracketSettings", "BracketShotNumber", "BracketStep", "BracketValue", "Brightness", "BrightnessValue", "BuildNumber", "BulbDuration", "BurstGroupID", "BurstMode", "BurstShot", "BurstSpeed", "BurstUUID", "ButtonFunctionControlOff", "BWFilter", "BWMode", "CAFArea", "CAFGridSize", "CAFPointsInFocus", "CAFPointsSelected", "Calibration", "CameraDateTime", "CameraID", "CameraISO", "CameraModel", "CameraOrientation", "CameraParameters", "CameraPictureStyle", "CameraPitch", "CameraRoll", "CameraSettingsVersion", "CameraType", "CameraYaw", "CanonExposureMode", "CanonFileDescription", "CanonFileLength", "CanonFirmwareVersion", "CanonFlashMode", "CanonImageHeight", "CanonImageSize", "CanonImageType", "CanonImageWidth", "CanonModelID", "CardShutterLock", "CaseAutoSetting", "Categories", "CCDBoardVersion", "CCDScanMode", "CCDSensitivity", "CCDVersion", "CenterAFArea", "CenterFocusPoint", "CenterWeightedAreaSize", "CHModeShootingSpeed", "ChromaticAberrationCorr", "ChromaticAberrationCorrection", "ChromaticAberrationCorrParams", "ChromaticAberrationSetting", "ChrominanceNoiseReduction", "City2", "Clarity", "ClarityControl", "ClearRetouch", "CLModeShootingSpeed", "CmdDialsApertureSetting", "CmdDialsChangeMainSub", "CmdDialsMenuAndPlayback", "CmdDialsReverseRotation", "CmdDialsReverseRotExposureComp", "ColorAdjustment", "ColorAdjustmentMode", "ColorBalanceBlue", "ColorBalanceGreen", "ColorBalanceRed", "ColorBalanceVersion", "ColorBitDepth", "ColorBW", "ColorChromeEffect", "ColorChromeFXBlue", "ColorCompensationFilter", "ColorCompensationFilterCustom", "ColorCompensationFilterSet", "ColorControl", "ColorCreatorEffect", "ColorDataVersion", "ColorEffect", "ColorFilter", "ColorGain", "ColorHue", "ColorMatrix", "ColorMatrixA", "ColorMatrixB", "ColorMatrixNumber", "ColorMode", "ColorProfileSettings", "ColorSpace", "ColorTempAsShot", "ColorTempAuto", "ColorTempCloudy", "ColorTempCustom", "ColorTempDaylight", "ColorTemperature", "ColorTemperatureAuto", "ColorTemperatureCustom", "ColorTemperatureSet", "ColorTemperatureSetting", "ColorTempFlash", "ColorTempFluorescent", "ColorTempKelvin", "ColorTempMeasured", "ColorTempShade", "ColorTempTungsten", "ColorTint", "ColorTone", "ColorToneAuto", "ColorToneFaithful", "ColorToneLandscape", "ColorToneNeutral", "ColorTonePortrait", "ColorToneStandard", "CommandDials", "CommandDialsApertureSetting", "CommandDialsChangeMainSub", "CommandDialsMenuAndPlayback", "CommandDialsReverseRotation", "CommanderChannel", "CommanderGroupAManualOutput", "CommanderGroupAMode", "CommanderGroupBManualOutput", "CommanderGroupBMode", "CommanderInternalFlash", "CommanderInternalManualOutput", "CommanderInternalTTLComp", "CommanderInternalTTLCompBuiltin", "CommanderInternalTTLCompGroupA", "CommanderInternalTTLCompGroupB", "Compass", "ComponentBitDepth", "ComponentVersion", "CompositeImageMode", "CompositionAdjust", "CompositionAdjustRotation", "CompositionAdjustX", "CompositionAdjustY", "CompressedImageSize", "Compression", "CompressionFactor", "CompressionRatio", "CompressorVersion", "ContentIdentifier", "ContinuousBracketing", "ContinuousDrive", "ContinuousModeDisplay", "ContinuousModeLiveView", "ContinuousShootingSpeed", "ContinuousShotLimit", "Contrast", "ContrastAuto", "ContrastCurve", "ContrastDetectAFArea", "ContrastDetectAFInFocus", "ContrastFaithful", "ContrastHighlight", "ContrastHighlightShadowAdj", "ContrastLandscape", "ContrastMode", "ContrastMonochrome", "ContrastNeutral", "ContrastPortrait", "ContrastSetting", "ContrastShadow", "ContrastStandard", "ControlDialSet", "ControllerBoardVersion", "ControlMode", "ControlRingResponse", "ControlRingRotation", "ConversionLens", "Converter", "Copyright", "CoringFilter", "CorrelatedColorTemp", "Country", "CountryCode", "CPUFirmwareVersion", "CPUVersions", "CreateDate", "CreativeStyle", "CreativeStyleSetting", "CropArea", "CropBottomMargin", "CropHeight", "CropHiSpeed", "CropLeft", "CropLeftMargin", "CropMode", "CroppedImageHeight", "CroppedImageLeft", "CroppedImageTop", "CroppedImageWidth", "CropRightMargin", "CropTop", "CropTopMargin", "CropWidth", "CrossProcess", "CustomControls", "CustomizeDials", "CustomPictureStyleFileName", "CustomRendered", "CustomSaturation", "CustomSettingsAllDefault", "CustomSettingsBank", "CustomWBBlueLevel", "CustomWBError", "CustomWBGreenLevel", "CustomWBRedLevel", "CustomWBSetting", "DarkFocusEnvironment", "DataDump", "DataScaling", "Date", "DateDisplayFormat", "DateImprint", "DateStampMode", "DateTimeOriginal", "DateTimeStamp", "DateTimeUTC", "DaylightSavings", "DECPosition", "DefaultEraseOption", "DeletedImageCount", "DestinationCity", "DestinationCityCode", "DestinationDST", "DevelopmentDynamicRange", "DeviceCodename", "DeviceHardwareRevision", "DeviceMake", "DeviceType", "DialDirectionTvAv", "DiffractionCompensation", "DiffractionCorrection", "DigitalFilter", "DigitalGain", "DigitalICE", "DigitalLensOptimizer", "DigitalLensOptimizerSetting", "DigitalZoom", "DigitalZoomOn", "DigitalZoomRatio", "DirectoryIndex", "DirectoryNumber", "DispButton", "DisplayAllAFPoints", "DisplayAperture", "DistortionControl", "DistortionCorrection", "DistortionCorrectionSetting", "DistortionCorrectionValue", "DistortionCorrectionVersion", "DistortionCorrParams", "DistortionCorrParamsNumber", "DistortionCorrParamsPresent", "DriveMode", "DriveModeSetting", "DriveSpeed", "DSPFirmwareVersion", "DualPixelRaw", "DustRemovalData", "DXCropAlert", "DynamicAFArea", "DynamicAreaAFAssist", "DynamicAreaAFDisplay", "DynamicRange", "DynamicRangeBoost", "DynamicRangeExpansion", "DynamicRangeOptimizer", "DynamicRangeOptimizerBracket", "DynamicRangeOptimizerLevel", "DynamicRangeOptimizerMode", "DynamicRangeOptimizerSetting", "DynamicRangeSetting", "EasyExposureComp", "EasyExposureCompensation", "EasyMode", "EffectiveLV", "EffectiveMaxAperture", "ElectronicFrontCurtainShutter", "Emissivity", "EnergySavingMode", "Enhancement", "Enhancer", "EpsonImageHeight", "EpsonImageWidth", "EpsonSoftware", "EquipmentVersion", "ETTLII", "EventNumber", "EVSteps", "EVStepSize", "ExitPupilPosition", "ExposureBracketingIndicatorLast", "ExposureBracketShotNumber", "ExposureBracketStepSize", "ExposureBracketValue", "ExposureCompAutoCancel", "ExposureCompensation", "ExposureCompensationMode", "ExposureCompensationSet", "ExposureCompensationSetting", "ExposureCompStepSize", "ExposureControlStep", "ExposureControlStepSize", "ExposureCount", "ExposureDelayMode", "ExposureDifference", "ExposureIndicator", "ExposureLevelIncrements", "ExposureMode", "ExposureModeInManual", "ExposureProgram", "ExposureShift", "ExposureStandardAdjustment", "ExposureTime", "ExposureTimeMax", "ExposureTimeMin", "ExposureTuning", "ExposureWarning", "EXRAuto", "EXRMode", "ExtendedMenuBanks", "ExtendedShutterSpeeds", "ExtendedWBDetect", "Extender", "ExtenderFirmwareVersion", "ExtenderModel", "ExtenderSerialNumber", "ExtenderStatus", "ExternalFlash", "ExternalFlashBounce", "ExternalFlashCompensation", "ExternalFlashExposureComp", "ExternalFlashFirmware", "ExternalFlashFlags", "ExternalFlashGuideNumber", "ExternalFlashGValue", "ExternalFlashMode", "ExternalFlashReadyState", "ExternalFlashStatus", "ExternalFlashZoom", "ExternalFlashZoomOverride", "ExternalSensorBrightnessValue", "ExtraInfoVersion", "EyeDetection", "EyeStartAF", "FaceDetect", "FaceDetectArea", "FaceDetectFrameCrop", "FaceDetectFrameSize", "FaceDetection", "FaceElementPositions", "FaceElementSelected", "FaceElementTypes", "FaceImageSize", "FaceInfoLength", "FaceInfoOffset", "FaceName", "FacePosition", "FacePositions", "FaceRecognition", "FacesDetected", "FacesDetectedA", "FacesDetectedB", "FacesRecognized", "FaceWidth", "Fade", "FEMicroadjustment", "FileFormat", "FileIndex", "FileInfoVersion", "FileNumber", "FileNumberMemory", "FileNumberSequence", "FileSource", "FillFlashAutoReduction", "FilmGrainEffect", "FilmMode", "FilmType", "FilterEffect", "FilterEffectAuto", "FilterEffectMonochrome", "FinderDisplayDuringExposure", "FineSharpness", "FineTuneOptCenterWeighted", "FineTuneOptHighlightWeighted", "FineTuneOptMatrixMetering", "FineTuneOptSpotMetering", "FinishedImage", "Firmware", "FirmwareDate", "FirmwareID", "FirmwareName", "FirmwareRevision", "FirmwareVersion", "FirstFrameActionInAFC", "FisheyeFilter", "Flash", "FlashAction", "FlashActionExternal", "FlashActivity", "FlashBatteryLevel", "FlashBias", "FlashBits", "FlashBurstPriority", "FlashButtonFunction", "FlashChargeLevel", "FlashColorFilter", "FlashCommanderMode", "FlashCompensation", "FlashControl", "FlashControlMode", "FlashCurtain", "FlashDefault", "FlashDevice", "FlashDistance", "FlashExposureBracketValue", "FlashExposureComp", "FlashExposureCompArea", "FlashExposureCompSet", "FlashExposureIndicator", "FlashExposureIndicatorLast", "FlashExposureIndicatorNext", "FlashExposureLock", "FlashFired", "FlashFiring", "FlashFirmwareVersion", "FlashFocalLength", "FlashFunction", "FlashGNDistance", "FlashGroupACompensation", "FlashGroupAControlMode", "FlashGroupBCompensation", "FlashGroupBControlMode", "FlashGroupCCompensation", "FlashGroupCControlMode", "FlashGuideNumber", "FlashIlluminationPattern", "FlashInfoVersion", "FlashIntensity", "FlashLevel", "FlashMasterControlMode", "FlashMetering", "FlashMeteringMode", "FlashMeteringSegments", "FlashMode", "FlashModel", "FlashOptions", "FlashOutput", "FlashRemoteControl", "FlashSerialNumber", "FlashSetting", "FlashSource", "FlashStatus", "FlashStatusExternal", "FlashSyncMode", "FlashSyncSpeed", "FlashSyncSpeedAv", "FlashThreshold", "FlashType", "FlashWarning", "FlexibleSpotPosition", "FlickAdvanceDirection", "FlickerReduce", "FlickerReduction", "FlickerReductionIndicator", "FlickerReductionShooting", "FlightDegree", "FlightSpeed", "FNumber", "FocalLength", "FocalLengthTeleZoom", "FocalPlaneAFPointArea", "FocalPlaneAFPointsUsed", "FocalPlaneDiagonal", "FocalPlaneXSize", "FocalPlaneYSize", "FocalType", "FocalUnits", "FocusArea", "FocusAreaSelection", "FocusBracket", "FocusBracketing", "FocusBracketStepSize", "FocusContinuous", "FocusDisplayAIServoAndMF", "FocusDistance", "FocusDistanceLower", "FocusDistanceRange", "FocusDistanceUpper", "FocusFrameSize", "FocusHoldButton", "FocusInfoVersion", "FocusingScreen", "FocusLocation", "FocusLocked", "FocusMode", "FocusModeSetting", "FocusModeSwitch", "FocusPeakingHighlightColor", "FocusPeakingLevel", "FocusPixel", "FocusPointBrightness", "FocusPointPersistence", "FocusPointSchema", "FocusPointSelectionSpeed", "FocusPointWrap", "FocusPosition", "FocusPositionHorizontal", "FocusPositionVertical", "FocusProcess", "FocusRange", "FocusRangeIndex", "FocusResult", "FocusRingRotation", "FocusSetting", "FocusShiftExposureLock", "FocusShiftInterval", "FocusShiftNumberShots", "FocusShiftShooting", "FocusShiftStepWidth", "FocusStatus", "FocusStepCount", "FocusStepInfinity", "FocusStepNear", "FocusTrackingLockOn", "FocusWarning", "FolderName", "FolderNumber", "FrameCount", "FrameNumber", "FrameRate", "FramingGridDisplay", "FreeBytes", "FreeMemoryCardImages", "FujiFlashMode", "FujiModel", "FullImageSize", "FullPressSnap", "Func1Button", "Func1ButtonPlusDials", "Func2Button", "Func3Button", "FuncButton", "FuncButtonPlusDials", "FunctionButton", "Gain", "GainBase", "GEImageSize", "GEMake", "GEModel", "GimbalDegree", "Gradation", "GrainEffectRoughness", "GrainEffectSize", "GrainyBWFilter", "GreenGain", "GridDisplay", "GripBatteryADLoad", "GripBatteryADNoLoad", "GripBatteryPercent", "GripBatteryState", "GripBatteryVoltage", "GroupAreaAFIllumination", "HDMIBitDepth", "HDMIExternalRecorder", "HDMIOutputRange", "HDMIOutputResolution", "HDR", "HDREffect", "HDRGain", "HDRHeadroom", "HDRImageType", "HDRInfoVersion", "HDRLevel", "HDRPSoftware", "HDRSetting", "HDRSmoothing", "HiddenDataLength", "HiddenDataOffset", "HighFrameRate", "HighISONoiseReduction", "Highlight", "Highlights", "HighlightShadow", "HighlightTone", "HighlightTonePriority", "HighlightWarning", "HighLowKeyAdj", "HighSpeedSync", "Histogram", "HometownCity", "HometownCityCode", "HometownDST", "HostSoftwareExportVersion", "HostSoftwareRendering", "Hue", "HueAdjust", "HueAdjustment", "HyperlapsDebugInfo", "Illumination", "ImageAdjustment", "ImageArea", "ImageAuthentication", "ImageBoundary", "ImageCaptureType", "ImageCount", "ImageData", "ImageDataSize", "ImageEditCount", "ImageEditing", "ImageEffects", "ImageGeneration", "ImageHeight", "ImageIDNumber", "ImageName", "ImageNumber", "ImageOptimization", "ImageProcessing", "ImageProcessingVersion", "ImageQuality", "ImageReview", "ImageReviewMonitorOffTime", "ImageReviewTime", "ImageRotated", "ImageSizeRAW", "ImageStabilization", "ImageStabilizationSetting", "ImageStyle", "ImageTemperatureMax", "ImageTemperatureMin", "ImageTone", "ImageUniqueID", "ImageWidth", "InfoButtonWhenShooting", "InfraredIlluminator", "InitialAFPointAIServoAF", "InitialAFPointInServo", "InitialZoomLiveView", "InitialZoomSetting", "InitParamsText", "InstantPlaybackSetup", "InstantPlaybackTime", "IntelligentAuto", "IntelligentContrast", "IntelligentExposure", "IntelligentResolution", "InternalFlash", "InternalFlashMode", "InternalFlashStrength", "InternalFlashTable", "InternalNDFilter", "InternalSerialNumber", "IntervalDurationHours", "IntervalDurationMinutes", "IntervalDurationSeconds", "IntervalExposureSmoothing", "IntervalLength", "IntervalMode", "IntervalNumber", "IntervalPriority", "Intervals", "IntervalShooting", "ISO", "ISO2", "ISOAuto", "ISOAutoFlashLimit", "ISOAutoHiLimit", "ISOAutoMax", "ISOAutoMin", "ISOAutoMinSpeed", "ISOAutoShutterTime", "ISODisplay", "ISOExpansion", "ISOFloor", "ISOMax", "ISOMin", "ISOSelected", "ISOSelection", "ISOSensitivityStep", "ISOSetting", "ISOSpeedExpansion", "ISOSpeedIncrements", "ISOSpeedRange", "ISOStepSize", "ISOValue", "JPEGQuality", "JPGCompression", "JpgRecordedPixels", "KeepExposure", "KeystoneCompensation", "KeystoneDirection", "KeystoneValue", "KodakImageHeight", "KodakImageWidth", "KodakInfoType", "KodakMake", "KodakMaker", "KodakModel", "KodakVersion", "Landmark", "Language", "LastFileNumber", "LateralChromaticAberration", "LCDDisplayAtPowerOn", "LCDDisplayReturnToShoot", "LCDIllumination", "LCDIlluminationDuringBulb", "LCDPanels", "Lens", "LensApertureRange", "LensControlRing", "LensDataVersion", "LensDistortionParams", "LensDriveNoAF", "LensDriveWhenAFImpossible", "LensFirmware", "LensFirmwareVersion", "LensFocalLength", "LensFocalRange", "LensFocusFunctionButtons", "LensFormat", "LensFStops", "LensFunc1Button", "LensFunc2Button", "LensID", "LensIDNumber", "LensInfo", "LensMaxApertureRange", "LensModel", "LensModulationOptimizer", "LensMount", "LensMountType", "LensPositionAbsolute", "LensProfileName", "LensProperties", "LensSerialNumber", "LensShading", "LensShutterLock", "LensSpec", "LensSpecFeatures", "LensTemperature", "LensType", "LensType2", "LensType3", "LensTypeMake", "LensTypeModel", "LensZoomPosition", "LevelIndicator", "LevelOrientation", "LightCondition", "LightingMode", "LightReading", "LightSource", "LightSourceSpecial", "LightSwitch", "LightValueCenter", "LightValuePeriphery", "LimitAFAreaModeSelection", "LinearityUpperMargin", "LinkAEToAFPoint", "LivePhotoVideoIndex", "LiveView", "LiveViewAF", "LiveViewAFAreaMode", "LiveViewAFMethod", "LiveViewAFMode", "LiveViewButtonOptions", "LiveViewExposureSimulation", "LiveViewFocusMode", "LiveViewMetering", "LiveViewMonitorOffTime", "LiveViewShooting", "LocalLocationName", "Location", "LocationInfoVersion", "LocationName", "LockMicrophoneButton", "LoggingMetadataText", "LongExposureNoiseReduction", "LongExposureNRUsed", "LowLightAF", "LuminanceNoiseAmplitude", "LuminanceNoiseReduction", "LVShootingAreaDisplay", "M16CVersion", "Macro", "MacroLED", "MacroMode", "MagicFilter", "MagnifiedView", "MainDialExposureComp", "Make", "MakerNoteOffset", "MakerNoteType", "MakerNoteVersion", "ManometerPressure", "ManometerReading", "ManualAFPointSelectPattern", "ManualAFPointSelPattern", "ManualFlash", "ManualFlashOutput", "ManualFlashStrength", "ManualFocusDistance", "ManualFocusPointIllumination", "ManualFocusRingInAFMode", "ManualTv", "MasterGain", "MatrixMetering", "MaxAnalogISO", "MaxAperture", "MaxApertureAtMaxFocal", "MaxApertureAtMinFocal", "MaxContinuousRelease", "MaxFaces", "MaxFocalLength", "MaxNumAFPoints", "MCCData", "MCUVersion", "MeasuredEV", "MeasuredLV", "MeasuredRGGB", "MeasuredRGGBData", "MechanicalShutterCount", "MemoAudioQuality", "MemoryCardConfiguration", "MemoryCardNumber", "MenuButtonDisplayPosition", "MenuButtonReturn", "MenuMonitorOffTime", "MergedImage", "MergedImages", "MetaVersion", "Metering", "MeteringButton", "MeteringFrameCount", "MeteringMode", "MeteringOffScaleIndicator", "MeteringTime", "MeterMode", "MidRangeSharpness", "MinAperture", "MinFocalLength", "MinFocusDistance", "MiniatureFilter", "MiniatureFilterOrientation", "MiniatureFilterParameter", "MiniatureFilterPosition", "MinimumISO", "MinoltaDate", "MinoltaImageSize", "MinoltaModelID", "MinoltaQuality", "MinoltaTime", "MirrorLockup", "ModeDialPosition", "Model", "ModelingFlash", "ModelReleaseYear", "ModifiedColorTemp", "ModifiedDigitalGain", "ModifiedParamFlag", "ModifiedPictureStyle", "ModifiedSaturation", "ModifiedSensorBlueLevel", "ModifiedSensorRedLevel", "ModifiedSharpness", "ModifiedSharpnessFreq", "ModifiedToneCurve", "ModifiedWhiteBalance", "ModifiedWhiteBalanceBlue", "ModifiedWhiteBalanceRed", "MonitorBrightness", "MonitorDisplayOff", "MonitorOffTime", "MonochromeColor", "MonochromeFilterEffect", "MonochromeGrainEffect", "MonochromeProfileSettings", "MonochromeToning", "MonochromeVignetting", "MonthDayCreated", "MoonPhase", "MotionSensitivity", "MovieAELockButtonAssignment", "MovieAFAreaMode", "MovieAFTrackingSensitivity", "MovieFlickerReduction", "MovieFunc1Button", "MovieFunc2Button", "MovieFunc3Button", "MovieFunctionButton", "MovieFunctionButtonPlusDials", "MovieHighlightDisplayPattern", "MovieHighlightDisplayThreshold", "MovieISOAutoControlManualMode", "MovieISOAutoHiLimit", "MovieLensControlRing", "MovieMultiSelector", "MoviePreviewButton", "MoviePreviewButtonPlusDials", "MovieShutterButton", "MovieSubSelectorAssignment", "MovieSubSelectorAssignmentPlusDials", "MovieType", "MovieWhiteBalanceSameAsPhoto", "MultiControllerWhileMetering", "MultiExposure", "MultiExposureAutoGain", "MultiExposureControl", "MultiExposureMode", "MultiExposureOverlayMode", "MultiExposureShots", "MultiExposureVersion", "MultiFrameNoiseReduction", "MultiFrameNREffect", "MultiFunctionLock", "MultipleExposureMode", "MultipleExposureSet", "MultiSelector", "MultiSelectorLiveView", "MultiSelectorPlaybackMode", "MultiSelectorShootMode", "MyColorMode", "NDFilter", "NEFBitDepth", "NEFCompression", "NEFLinearizationTable", "NeutralDensityFilter", "NikonCaptureVersion", "NikonImageSize", "NikonMeteringMode", "NoiseFilter", "NoiseReduction", "NoiseReductionStrength", "NoMemoryCard", "NominalMaxAperture", "NominalMinAperture", "NormalWhiteLevel", "NumAFPoints", "NumberOfFocusPoints", "NumberOffsets", "NumCAFPoints", "NumFaceElements", "NumFacePositions", "ObjectDistance", "OISMode", "OKButton", "OlympusImageHeight", "OlympusImageWidth", "OneTouchWB", "OpticalVR", "OpticalZoom", "OpticalZoomCode", "OpticalZoomMode", "OpticalZoomOn", "OrderNumber", "OrientationLinkedAF", "OrientationLinkedAFPoint", "OriginalDecisionDataOffset", "OriginalDirectory", "OriginalFileName", "OriginalImageHeight", "OriginalImageWidth", "OriginalPayloadFrameCount", "OtherInfo", "OutputLUT", "OwnerName", "PaintingFilter", "PanasonicDateTime", "PanasonicExifVersion", "PanasonicImageHeight", "PanasonicImageWidth", "PanoramaAngle", "PanoramaCropBottom", "PanoramaCropLeft", "PanoramaCropRight", "PanoramaCropTop", "PanoramaDirection", "PanoramaFrameHeight", "PanoramaFrameWidth", "PanoramaFullHeight", "PanoramaFullWidth", "PanoramaMode", "PanoramaSize3D", "PanoramaSourceHeight", "PanoramaSourceWidth", "PayloadMetadataText", "PentaxImageSize", "PentaxModelID", "PentaxModelType", "PerChannelBlackLevel", "PeripheralIlluminationCorr", "PeripheralLighting", "PeripheralLightingSetting", "PeripheralLightingValue", "PhaseDetectAF", "PhotoEffect", "PhotoIdentifier", "PhotoInfoPlayback", "PhotosAppFeatureFlags", "PhotoShootingMenuBank", "PhotoShootingMenuBankImageArea", "PhotoStyle", "PictureControlAdjust", "PictureControlBase", "PictureControlName", "PictureControlQuickAdjust", "PictureControlVersion", "PictureEffect", "PictureFinish", "PictureMode", "PictureModeBWFilter", "PictureModeContrast", "PictureModeEffect", "PictureModeSaturation", "PictureModeSharpness", "PictureModeStrength", "PictureModeTone", "PictureProfile", "PictureStyle", "PictureStylePC", "PictureStyleUserDef", "Pitch", "PitchAngle", "PixelAspectRatio", "PixelShiftID", "PixelShiftInfo", "PixelShiftResolution", "PixelShiftShooting", "PlaybackFlickDown", "PlaybackFlickUp", "PlaybackMenusTime", "PlaybackMonitorOffTime", "PlaybackZoom", "PlayDisplay", "POILevel", "PopupFlash", "PortraitImpressionBalance", "PortraitRefiner", "PostFocusMerging", "PostReleaseBurstLength", "PowerAvailable", "PowerSource", "PowerUpTime", "PreAF", "PreCaptureFrames", "PreReleaseBurstLength", "PresetWhiteBalance", "PreviewButton", "PreviewButtonPlusDials", "PreviewImage", "PreviewImageBorders", "PreviewImageHeight", "PreviewImageLength", "PreviewImageSize", "PreviewImageStart", "PreviewImageValid", "PreviewImageWidth", "PreviewQuality", "PrimaryAFPoint", "PrimarySlot", "PrioritySetupShutterRelease", "ProcessingNotes", "ProductionCode", "ProgramISO", "ProgramLine", "ProgramMode", "ProgramShift", "Quality", "QuickControlDialInMeter", "QuickShot", "QuietShutterShootingSpeed", "RangeFinder", "Rating", "RawAndJpgRecording", "RawBurstImageCount", "RawBurstImageNum", "RawDataByteOrder", "RawDataCFAPattern", "RawDataLength", "RawDepth", "RawDevArtFilter", "RawDevAutoGradation", "RawDevColorSpace", "RawDevContrastValue", "RawDevEditStatus", "RawDevelopmentProcess", "RawDevEngine", "RawDevExposureBiasValue", "RawDevGradation", "RawDevGrayPoint", "RawDevMemoryColorEmphasis", "RawDevNoiseReduction", "RawDevPictureMode", "RawDevPMContrast", "RawDevPMNoiseFilter", "RawDevPMPictureTone", "RawDevPMSaturation", "RawDevPMSharpness", "RawDevSaturationEmphasis", "RawDevSettings", "RawDevSharpnessValue", "RawDevVersion", "RawDevWBFineAdjustment", "RawDevWhiteBalance", "RawDevWhiteBalanceValue", "RAWFileType", "RawImageCenter", "RawImageHeight", "RawImageWidth", "RawJpgQuality", "RawJpgSize", "RawMeasuredRGGB", "RearControPanelDisplay", "RearDisplay", "RecordDisplay", "RecordID", "RecordingFormat", "RecordingMode", "RecordMode", "RecordShutterRelease", "RectifaceText", "RedBalance", "RedEyeReduction", "RedEyeRemoval", "RedGain", "ReleaseButtonToUseDial", "ReleaseMode", "RemoteFuncButton", "RemoteOnDuration", "RepeatingFlashCount", "RepeatingFlashOutput", "RepeatingFlashOutputExternal", "RepeatingFlashRate", "Resaved", "Resolution", "ResolutionMode", "ResolutionUnit", "RestrictDriveModes", "RetouchHistory", "RetouchInfoVersion", "RetouchNEFProcessing", "RetractLensOnPowerOff", "ReverseExposureCompDial", "ReverseFocusRing", "ReverseIndicators", "ReverseShutterSpeedAperture", "RFLensMFFocusRingSensitivity", "RFLensType", "RicohDate", "RicohImageHeight", "RicohImageWidth", "RicohMake", "RicohModel", "Roll", "RollAngle", "ROMOperationMode", "Rotation", "RunTimeEpoch", "RunTimeFlags", "RunTimeScale", "RunTimeValue", "SafetyShift", "SafetyShiftInAvOrTv", "SameExposureForNewAperture", "SamsungModelID", "SanyoQuality", "SanyoThumbnail", "Saturation", "SaturationAdj", "SaturationAuto", "SaturationFaithful", "SaturationLandscape", "SaturationNeutral", "SaturationPortrait", "SaturationSetting", "SaturationStandard", "SaveFocus", "ScanImageEnhancer", "SceneAssist", "SceneDetect", "SceneMode", "SceneModeUsed", "SceneRecognition", "SceneSelect", "ScreenTips", "SecondarySlotFunction", "SelectableAFPoint", "SelectAFAreaSelectionMode", "SelectAFAreaSelectMode", "SelfTimer", "SelfTimerInterval", "SelfTimerShotCount", "SelfTimerShotInterval", "SelfTimerTime", "SemanticStyle", "SemanticStylePreset", "SemanticStyleRenderingVer", "SensitivityAdjust", "SensitivitySteps", "Sensor", "SensorBitDepth", "SensorBlueLevel", "SensorBottomBorder", "SensorCalibration", "SensorCleaning", "SensorFullHeight", "SensorFullWidth", "SensorHeight", "SensorID", "SensorLeftBorder", "SensorPixelSize", "SensorRedLevel", "SensorRightBorder", "SensorSize", "SensorTemperature", "SensorTopBorder", "SensorType", "SensorWidth", "Sequence", "SequenceFileNumber", "SequenceImageNumber", "SequenceLength", "SequenceNumber", "SequenceShotInterval", "SequentialShot", "SerialNumber", "SerialNumberFormat", "ServoAFCharacteristics", "SetButtonCrossKeysFunc", "SetButtonWhenShooting", "SetFunctionWhenShooting", "ShadingCompensation", "Shadow", "ShadowCorrection", "Shadows", "ShadowTone", "ShakeReduction", "Sharpening", "Sharpness", "SharpnessAuto", "SharpnessFactor", "SharpnessFaithful", "SharpnessFreqTable", "SharpnessFrequency", "SharpnessLandscape", "SharpnessMonochrome", "SharpnessNeutral", "SharpnessPortrait", "SharpnessRange", "SharpnessSetting", "SharpnessStandard", "SharpnessTable", "ShootingInfoDisplay", "ShootingInfoMonitorOffTime", "ShootingMode", "ShootingModeSetting", "ShortOwnerName", "ShortReleaseTimeLag", "ShotInfoVersion", "ShotLogDataText", "ShotNumber", "ShotNumberSincePowerUp", "ShotParamsText", "ShotsPerInterval", "Shutter", "ShutterAELButton", "ShutterButtonAFOnButton", "ShutterCount", "ShutterCount2", "ShutterCount3", "ShutterCurtainSync", "ShutterMode", "ShutterReleaseMethod", "ShutterReleaseNoCFCard", "ShutterReleaseTiming", "ShutterReleaseWithoutLens", "ShutterSpeed", "ShutterSpeedLock", "ShutterSpeedRange", "ShutterSpeedSetting", "ShutterSpeedValue", "ShutterType", "SignalToNoiseRatio", "SilentPhotography", "SingleFrame", "SingleFrameBracketing", "SkinToneCorrection", "SlaveFlashMeteringSegments", "SlowShutter", "SlowSync", "SmartAlbumColor", "SmileShutter", "SmileShutterMode", "SoftFocusFilter", "SoftSkinEffect", "Software", "SoftwareDate", "SonyDateTime", "SonyDateTime2", "SonyExposureTime", "SonyFNumber", "SonyImageHeight", "SonyImageHeightMax", "SonyImageSize", "SonyImageWidth", "SonyImageWidthMax", "SonyISO", "SonyMaxAperture", "SonyMaxApertureValue", "SonyMinAperture", "SonyModelID", "SonyQuality", "SonyTimeMinSec", "SourceDirectoryIndex", "SourceFileIndex", "SpecialEffectLevel", "SpecialEffectMode", "SpecialEffectSetting", "SpecialMode", "SpecularWhiteLevel", "SpeedX", "SpeedY", "SpeedZ", "SportEvents", "SpotFocusPointX", "SpotFocusPointY", "SpotMeteringMode", "SpotMeterLinkToAFPoint", "SRActive", "SRAWQuality", "SRFocalLength", "SRHalfPressTime", "SRResult", "StackedImage", "StandbyMonitorOffTime", "StandbyTimer", "StartMovieShooting", "State", "StaticMetadataText", "StepCropShooting", "StopsAboveBaseISO", "StorageMethod", "StoreByOrientation", "SubDialFrameAdvance", "SubjectDetectArea", "SubjectDetectDetail", "SubjectDetectFrameSize", "SubjectDetection", "SubjectDetectionAreaMF", "SubjectDetectStatus", "SubjectMotion", "SubjectProgram", "SubjectRecognition", "SubjectSwitching", "SubjectToDetect", "SubSelector", "SubSelectorAssignment", "SubSelectorCenter", "SubSelectorPlusDials", "SummaryText", "SuperimposedDisplay", "SuperMacro", "SvISOSetting", "SweepPanoramaDirection", "SweepPanoramaFieldOfView", "SweepPanoramaSize", "SwitchToRegisteredAFPoint", "SyncReleaseMode", "TargetAperture", "TargetCompressionRatio", "TargetDistanceSetting", "TargetExposureTime", "TargetImageType", "Teleconverter", "TextEncoding", "TextStamp", "ThumbnailFileName", "ThumbnailHeight", "ThumbnailImage", "ThumbnailImageValidArea", "ThumbnailLength", "ThumbnailWidth", "TiffMeteringImage", "TiffMeteringImageHeight", "TiffMeteringImageWidth", "Time", "TimeCreated", "TimeLapseShotNumber", "TimeLogText", "TimerFunctionButton", "TimerLength", "TimerRecording", "TimeSincePowerOn", "TimeStamp", "TimeZone", "TimeZoneCity", "TimeZoneCode", "TimeZoneInfo", "Title", "ToneComp", "ToneCurve", "ToneCurveMatching", "ToneCurveTable", "ToneLevel", "ToningEffect", "ToningEffectAuto", "ToningEffectMonochrome", "ToningSaturation", "TotalZoom", "TouchAE", "ToyCameraFilter", "Transform", "TrashButtonFunction", "TravelDay", "TriggerMode", "TvExposureTimeSetting", "UniqueID", "UnknownNumber", "UnsharpMaskFineness", "UnsharpMaskThreshold", "UnusedLoggingMetadata", "UsableMeteringModes", "UsableShootingModes", "USBPowerDelivery", "UserDef1PictureStyle", "UserDef2PictureStyle", "UserDef3PictureStyle", "UserLabel", "UserProfile", "USMLensElectronicMF", "ValidAFPoints", "ValidBits", "VariableLowPassFilter", "VariProgram", "Version", "VerticalAFOnButton", "VerticalFuncButton", "VerticalFuncButtonPlusDials", "VerticalMovieAFOnButton", "VerticalMovieFuncButton", "VerticalMultiSelector", "VFDisplayIllumination", "VibrationReduction", "VideoBurstMode", "VideoBurstResolution", "VideoFrameRate", "VideoPreburst", "ViewfinderDisplay", "ViewfinderWarning", "ViewfinderWarnings", "ViewInfoDuringExposure", "ViewingMode", "Vignette", "VignetteControl", "VignetteCorrectionVersion", "Vignetting", "VignettingCorrection", "VignettingCorrParams", "VignettingCorrVersion", "VoiceMemo", "VRDOffset", "VRInfoVersion", "VRMode", "VRType", "WatercolorFilter", "WBBlue", "WBBlueLevel", "WBBracketingSteps", "WBBracketMode", "WBBracketShotNumber", "WBBracketValueAB", "WBBracketValueGM", "WBButtonPlaybackMode", "WBGreen", "WBGreenLevel", "WBMediaImageSizeSetting", "WBMode", "WBRed", "WBRedLevel", "WBScale", "WBShiftAB", "WBShiftCreativeControl", "WBShiftGM", "WBShiftIntelligentAuto", "WhiteBalance", "WhiteBalanceAutoAdjustment", "WhiteBalanceBias", "WhiteBalanceBlue", "WhiteBalanceBracket", "WhiteBalanceBracketing", "WhiteBalanceFineTune", "WhiteBalanceMatching", "WhiteBalanceMode", "WhiteBalanceRed", "WhiteBalanceSet", "WhiteBalanceSetting", "WhiteBalanceSetup", "WhiteBalanceTable", "WhiteBalanceTemperature", "WhiteBoard", "WhiteLevel", "WhitePoint", "WholeAreaTracking", "WideAdapter", "WideFocusZone", "WideRange", "WorldTimeLocation", "X3FillLight", "Xidiri", "XResolution", "Yaw", "YawAngle", "YCbCrCoefficients", "YCbCrPositioning", "YearCreated", "YResolution", "ZoneMatching", "ZoneMatchingMode", "ZoneMatchingOn", "ZoneMatchingValue", "ZoomedPreviewImage", "ZoomedPreviewLength", "ZoomedPreviewSize", "ZoomedPreviewStart", "ZoomSourceWidth", "ZoomStepCount", "ZoomTargetWidth");
exports.XMPTagsNames = (0, StrEnum_1.strEnum)("About", "AbsoluteAltitude", "Album", "AlreadyApplied", "AltitudeType", "ApertureValue", "ApproximateFocusDistance", "AsrClimaxDuration", "AsrClimaxScene", "AsrIsMacroRange", "AsrSceneCondition", "AsrSceneMode", "AutoLateralCA", "BandName", "BitsPerSample", "BlueHue", "BlueSaturation", "Brightness", "BrightnessValue", "BurstID", "BurstPrimary", "CameraBurstID", "CameraFacing", "CameraModelID", "CameraProfile", "CameraProfileDigest", "Cameras", "CameraSerialNumber", "CamReverse", "CaptureMode", "CaptureSoftware", "CatalogSets", "Categories", "CellGlobalID", "CellR", "CellTowerID", "CentralTemperature", "CentralWavelength", "Changes", "ChromaticAberrationB", "ChromaticAberrationR", "CircularGradientBasedCorrections", "ColorClass", "ColorGradeBlending", "ColorGradeGlobalHue", "ColorGradeGlobalLum", "ColorGradeGlobalSat", "ColorGradeHighlightLum", "ColorGradeMidtoneHue", "ColorGradeMidtoneLum", "ColorGradeMidtoneSat", "ColorGradeShadowLum", "ColorLabel", "Colorlabels", "ColorMode", "ColorNoiseReduction", "ColorNoiseReductionDetail", "ColorNoiseReductionSmoothness", "ColorSpace", "ColorTemperature", "Comment", "CompressedBitsPerPixel", "Compression", "Container", "ContainerDirectory", "Contrast", "ConvertToGrayscale", "Country", "CountryCode", "CreateDate", "CreationTime", "Creator", "CreatorAppID", "CreatorContactInfo", "CreatorOpenWithUIOptions", "Creatortool", "CreatorTool", "CropAngle", "CropBottom", "CropConstrainToWarp", "CropHeight", "CropLeft", "CroppedAreaImageHeightPixels", "CroppedAreaImageWidthPixels", "CroppedAreaLeftPixels", "CroppedAreaTopPixels", "CropRight", "CropTop", "CropWidth", "CustomRendered", "DateAcquired", "DateCreated", "DateTime", "DateTimeDigitized", "DateTimeOriginal", "DateUTC", "DefringeGreenAmount", "DefringeGreenHueHi", "DefringeGreenHueLo", "DefringePurpleAmount", "DefringePurpleHueHi", "DefringePurpleHueLo", "Dehaze", "DepthImage", "DerivedFrom", "Description", "DigitalZoomRatio", "DisableAutoCreation", "DistortionCorrectionAlreadyApplied", "DocumentID", "DroneModel", "DroneSerialNumber", "Duration", "ExifImageHeight", "ExifImageWidth", "ExifVersion", "Exposure", "ExposureCompensation", "ExposureMode", "ExposureProgram", "ExposureTime", "Face", "FaceNum", "FaceSelectedIndex", "Far", "FileSource", "Filters", "Firmware", "Flash", "FlashCompensation", "FlashManufacturer", "FlashModel", "FlashPixVersion", "FlightPitchDegree", "FlightRollDegree", "FlightXSpeed", "FlightYawDegree", "FlightYSpeed", "FlightZSpeed", "FNumber", "FocalLength", "FocalLengthIn35mmFormat", "FocalPlaneResolutionUnit", "FocalPlaneXResolution", "FocalPlaneYResolution", "FocusAreaHeight", "FocusAreaNum", "FocusAreaWidth", "FocusDistance", "FocusIsLensMoving", "FocusPosX", "FocusPosY", "FocusState", "Format", "FullPanoHeightPixels", "FullPanoWidthPixels", "GainControl", "GimbalPitchDegree", "GimbalReverse", "GimbalRollDegree", "GimbalYawDegree", "GPSAltitude", "GPSAltitudeRef", "GPSDateStamp", "GPSDateTime", "GPSDOP", "GPSImgDirection", "GPSImgDirectionRef", "GPSLatitude", "GPSLongitude", "GPSLongitudeRef", "GPSMapDatum", "GPSProcessingMethod", "GPSSpeed", "GPSSpeedRef", "GpsStatus", "GPSVersionID", "GrainAmount", "GreenHue", "GreenSaturation", "HasCrop", "HasExtendedXMP", "HasSettings", "HDRPlusMakerNote", "HDRPMakerNote", "HierarchicalSubject", "History", "HueAdjustmentAqua", "HueAdjustmentBlue", "HueAdjustmentGreen", "HueAdjustmentMagenta", "HueAdjustmentOrange", "HueAdjustmentPurple", "HueAdjustmentRed", "HueAdjustmentYellow", "ICCProfileName", "ImageData", "ImageHeight", "ImageLength", "ImageMimeType", "ImageNumber", "ImageSource", "ImageUniqueID", "ImageWidth", "InitialViewHeadingDegrees", "InitialViewPitchDegrees", "InitialViewRollDegrees", "InstanceID", "InteroperabilityIndex", "InteroperabilityVersion", "IsBokehActive", "IsHDRActive", "IsNightModeActive", "ISO", "ISOSpeed", "Label", "LastKeywordXMP", "LateralChromaticAberrationCorrectionAlreadyApplied", "LegacyIPTCDigest", "Lens", "LensFacing", "LensID", "LensInfo", "LensMake", "LensManualDistortionAmount", "LensManufacturer", "LensModel", "LensProfileDigest", "LensProfileDistortionScale", "LensProfileEnable", "LensProfileIsEmbedded", "LensProfileName", "LensProfileSetup", "LensProfileVignettingScale", "LensSerialNumber", "LightSource", "LocationAreaCode", "Look", "LuminanceAdjustmentAqua", "LuminanceAdjustmentBlue", "LuminanceAdjustmentGreen", "LuminanceAdjustmentMagenta", "LuminanceAdjustmentOrange", "LuminanceAdjustmentPurple", "LuminanceAdjustmentRed", "LuminanceAdjustmentYellow", "LuminanceNoiseReductionContrast", "LuminanceNoiseReductionDetail", "LuminanceSmoothing", "Make", "MakerNote", "Marked", "Mask", "MaxApertureValue", "MetadataDate", "MeteringMode", "MicroVideo", "MicroVideoOffset", "MicroVideoPresentationTimestampUs", "MicroVideoVersion", "Mime", "MinorVersion", "MobileCountryCode", "MobileNetworkCode", "Model", "ModificationDate", "ModifyDate", "MotionPhoto", "MotionPhotoPresentationTimestampUs", "MotionPhotoVersion", "NativeDigest", "Near", "Notes", "ObjectAreaHeight", "ObjectAreaWidth", "ObjectNum", "ObjectPosX", "ObjectPosY", "Orientation", "OriginalCreateDateTime", "OriginalDocumentID", "OverrideLookVignette", "Padding", "ParametricDarks", "ParametricHighlights", "ParametricHighlightSplit", "ParametricLights", "ParametricMidtoneSplit", "ParametricShadows", "ParametricShadowSplit", "PersonInImage", "PerspectiveAspect", "PerspectiveHorizontal", "PerspectiveRotate", "PerspectiveScale", "PerspectiveUpright", "PerspectiveVertical", "PerspectiveX", "PerspectiveY", "PhotographicSensitivity", "PhotometricInterpretation", "PickLabel", "PipelineVersion", "PMVersion", "PortraitVersion", "PoseHeadingDegrees", "PosePitchDegrees", "PoseRollDegrees", "PostCropVignetteAmount", "PreservedFileName", "ProcessVersion", "Profiles", "ProgramMode", "ProjectionType", "Rating", "RatingPercent", "RawFileName", "RecommendedExposureIndex", "RedHue", "RedSaturation", "RegionInfo", "RegionInfoMP", "RegistryID", "RelativeAltitude", "ResolutionUnit", "Rights", "SamplesPerPixel", "Saturation", "SaturationAdjustmentAqua", "SaturationAdjustmentBlue", "SaturationAdjustmentGreen", "SaturationAdjustmentMagenta", "SaturationAdjustmentOrange", "SaturationAdjustmentPurple", "SaturationAdjustmentRed", "SaturationAdjustmentYellow", "Scene", "SceneCaptureType", "SceneDetectResultConfidences", "SceneDetectResultIds", "SceneType", "SelfData", "SensingMethod", "SensitivityType", "SerialNumber", "Shadows", "ShadowTint", "SharpenDetail", "SharpenEdgeMasking", "SharpenRadius", "Sharpness", "ShotLogData", "ShutterSpeedValue", "ShutterType", "Software", "SourcePhotosCount", "SpecialTypeID", "SplitToningBalance", "SplitToningHighlightHue", "SplitToningHighlightSaturation", "SplitToningShadowHue", "SplitToningShadowSaturation", "State", "StitchingSoftware", "StreamType", "Subject", "SubjectDistance", "SubjectDistanceRange", "SubsecTime", "SubSecTimeDigitized", "SubSecTimeOriginal", "SurveyingMode", "Tag", "Tagged", "TagsList", "Texture", "Tint", "Title", "TlinearGain", "ToneCurve", "ToneCurveBlue", "ToneCurveGreen", "ToneCurveName", "ToneCurvePV2012Blue", "ToneCurvePV2012Green", "ToneCurvePV2012Red", "ToneCurveRed", "ToneMapStrength", "UprightCenterMode", "UprightCenterNormX", "UprightCenterNormY", "UprightFocalLength35mm", "UprightFocalMode", "UprightFourSegmentsCount", "UprightPreview", "UprightTransformCount", "UprightVersion", "UsePanoramaViewer", "UserComment", "UTCAtExposure", "Version", "Versions", "Vibrance", "VignetteAmount", "WavelengthFWHM", "WhiteBalance", "XMPMeta", "XMPToolkit", "XResolution", "YCbCrPositioning", "YResolution");
/**
 * All tag names combined from all interfaces
 */
exports.TagNames = (0, StrEnum_1.strEnum)(...exports.ExifToolTagsNames.values, ...exports.FileTagsNames.values, ...exports.CompositeTagsNames.values, ...exports.APPTagsNames.values, ...exports.DuckyTagsNames.values, ...exports.FlashPixTagsNames.values, ...exports.EXIFTagsNames.values, ...exports.JPEGTagsNames.values, ...exports.JSONTagsNames.values, ...exports.JUMBFTagsNames.values, ...exports.MPFTagsNames.values, ...exports.MetaTagsNames.values, ...exports.PanasonicRawTagsNames.values, ...exports.PhotoshopTagsNames.values, ...exports.PrintIMTagsNames.values, ...exports.IPTCTagsNames.values, ...exports.QuickTimeTagsNames.values, ...exports.RAFTagsNames.values, ...exports.RIFFTagsNames.values, ...exports.JFIFTagsNames.values, ...exports.MakerNotesTagsNames.values, ...exports.XMPTagsNames.values, ...ExifToolVendoredTags_1.ExifToolVendoredTagNames.values, ...GeolocationTags_1.GeolocationTagNames.values, ...ImageDataHashTag_1.ImageDataHashTagNames.values, ...ICCProfileTags_1.ICCProfileTagNames.values, ...IPTCApplicationRecordTags_1.IPTCApplicationRecordTagNames.values, ...MWGTags_1.MWGCollectionsTagNames.values, ...MWGTags_1.MWGKeywordTagNames.values);
//# sourceMappingURL=Tags.js.map