import { DefinedOrNullValued } from "./Defined";
import { ErrorsAndWarnings } from "./ErrorsAndWarnings";
import { ExifDate } from "./ExifDate";
import { ExifDateTime } from "./ExifDateTime";
import { ResourceEvent } from "./ResourceEvent";
import { ShortcutTags } from "./ShortcutTags";
import { ExifToolTags, FileTags, Tags } from "./Tags";
import { Version } from "./Version";
export interface StructAppendTags {
    /**
     * Use this to **append** to existing History records.
     */
    "History+"?: ResourceEvent | ResourceEvent[];
    /**
     * Use this to **append** to existing Version records.
     */
    "Versions+"?: Version | Version[];
}
export type AdditionalWriteTags = {
    "Orientation#"?: number;
};
/**
 * Tags, minus the ExifToolTags, (most) FileTags, and ErrorsAndWarnings, all of
 * which aren't writable.
 *
 * Tags that appear in FileTags AND other writable groups (like `Comment`, which
 * is in both FileTags and XMPTags) are kept writable via the Exclude in the
 * Omit. Plainly, we're excluding everything in `ExifToolTags`, `FileTags`, and
 * `ErrorsAndWarnings` _except_ for `Comment`.
 *
 * **CAREFUL**: this contains (many!) additional non-mutable fields--please
 * check the ExifTool documentation to see which fields from which groups are
 * writable for your given file type.
 */
export type MutableTags = Omit<Tags, Exclude<keyof ExifToolTags | keyof FileTags | keyof ErrorsAndWarnings, "Comment">>;
export type ExpandedDateTags = {
    [K in keyof MutableTags]: (MutableTags[K] extends ExifDateTime | string ? ExifDate | ExifDateTime | number : MutableTags[K]) | string | number;
};
export type WritableGPSRefs = {
    GPSAltitudeRef?: string | number | null;
    GPSLatitudeRef?: string | number | null;
    GPSLongitudeRef?: string | number | null;
};
export type XMPPartialDateTags = {
    "XMP:CreateDate"?: ExifDate | ExifDateTime | string | number;
    "XMP:MetadataDate"?: ExifDate | ExifDateTime | string | number;
    "XMP:ModifyDate"?: ExifDate | ExifDateTime | string | number;
    "XMP:DateCreated"?: ExifDate | ExifDateTime | string | number;
    "XMP:DateTimeOriginal"?: ExifDate | ExifDateTime | string | number;
    "XMP:DateTimeDigitized"?: ExifDate | ExifDateTime | string | number;
};
export type EXIFStrictDateTags = {
    "EXIF:CreateDate"?: ExifDateTime | string;
    "EXIF:DateTimeOriginal"?: ExifDateTime | string;
    "EXIF:ModifyDate"?: ExifDateTime | string;
    "EXIF:DateTimeDigitized"?: ExifDateTime | string;
};
export type GroupPrefixedTags = XMPPartialDateTags & EXIFStrictDateTags;
export type WriteTags = Omit<DefinedOrNullValued<ShortcutTags & AdditionalWriteTags & ExpandedDateTags & StructAppendTags>, keyof WritableGPSRefs> & WritableGPSRefs & GroupPrefixedTags;
