"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.mts
var index_exports = {};
__export(index_exports, {
  PostgresJSDialect: () => PostgresJSDialect,
  PostgresJSDialectError: () => PostgresJSDialectError,
  PostgresJSDriver: () => PostgresJSDriver
});
module.exports = __toCommonJS(index_exports);

// src/dialect.mts
var import_kysely2 = require("kysely");

// src/driver.mts
var import_kysely = require("kysely");

// src/utils.mts
function freeze(obj) {
  return Object.freeze(obj);
}

// src/driver.mts
var RELEASE_CONNECTION_SYMBOL = Symbol("release");
var PostgresJSDriver = class extends import_kysely.PostgresDriver {
  #config;
  #postgres;
  constructor(config) {
    super({});
    this.#config = freeze({ ...config });
  }
  async acquireConnection() {
    const reservedConnection = await this.#postgres.reserve();
    const connection = new PostgresJSConnection(reservedConnection);
    await this.#config.onReserveConnection?.(connection);
    return connection;
  }
  async destroy() {
    await this.#postgres.end();
  }
  async init() {
    const { postgres } = this.#config;
    this.#postgres = isPostgresJSSql(postgres) ? postgres : await postgres();
  }
  async releaseConnection(connection) {
    ;
    connection[RELEASE_CONNECTION_SYMBOL]();
  }
};
function isPostgresJSSql(thing) {
  return typeof thing === "function" && "reserve" in thing;
}
var PostgresJSConnection = class {
  #reservedConnection;
  constructor(reservedConnection) {
    this.#reservedConnection = reservedConnection;
  }
  async executeQuery(compiledQuery) {
    const result = await this.#reservedConnection.unsafe(compiledQuery.sql, [
      ...compiledQuery.parameters
    ]);
    const { command, count } = result;
    return {
      numAffectedRows: command === "INSERT" || command === "UPDATE" || command === "DELETE" || command === "MERGE" ? BigInt(count) : void 0,
      rows: Array.from(result.values())
    };
  }
  async *streamQuery(compiledQuery, chunkSize) {
    if (!Number.isInteger(chunkSize) || chunkSize <= 0) {
      throw new PostgresJSDialectError("chunkSize must be a positive integer");
    }
    const query = this.#reservedConnection.unsafe(compiledQuery.sql, [
      ...compiledQuery.parameters
    ]);
    if (typeof query.cursor !== "function") {
      throw new Error(
        "PostgresJSDialect detected the instance you passed to it does not support streaming."
      );
    }
    const cursor = query.cursor(chunkSize);
    for await (const rows of cursor) {
      yield { rows };
    }
  }
  [RELEASE_CONNECTION_SYMBOL]() {
    this.#reservedConnection.release();
  }
};
var PostgresJSDialectError = class extends Error {
  constructor(message) {
    super(message);
    this.name = "PostgresJSDialectError";
  }
};

// src/dialect.mts
var PostgresJSDialect = class {
  #config;
  constructor(config) {
    this.#config = freeze({ ...config });
  }
  createAdapter() {
    return new import_kysely2.PostgresAdapter();
  }
  createDriver() {
    return new PostgresJSDriver(this.#config);
  }
  // biome-ignore lint/suspicious/noExplicitAny: this is fine.
  createIntrospector(db) {
    return new import_kysely2.PostgresIntrospector(db);
  }
  createQueryCompiler() {
    return new import_kysely2.PostgresQueryCompiler();
  }
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  PostgresJSDialect,
  PostgresJSDialectError,
  PostgresJSDriver
});
