"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommandRunner = void 0;
const constants_1 = require("./constants");
class CommandRunner {
    static registerWithSubCommands(meta = constants_1.CommandMeta) {
        var _a;
        // NOTE: "this' in the scope is inherited class
        const subcommands = ((_a = Reflect.getMetadata(meta, this)) === null || _a === void 0 ? void 0 : _a.subCommands) || [];
        return subcommands.reduce((current, subcommandClass) => {
            const results = subcommandClass.registerWithSubCommands(constants_1.SubCommandMeta);
            return [...current, ...results];
        }, [this]);
    }
    setCommand(command) {
        this.command = command;
        return this;
    }
}
exports.CommandRunner = CommandRunner;
//# sourceMappingURL=command-runner.interface.js.map