import { SourceType } from 'src/enum';
import { assetStub } from 'test/fixtures/asset.stub';
import { personStub } from 'test/fixtures/person.stub';

export const faceStub = {
  face1: Object.freeze({
    id: 'assetFaceId1',
    assetId: assetStub.image.id,
    asset: {
      ...assetStub.image,
      libraryId: null,
      updateId: '0d1173e3-4d80-4d76-b41e-57d56de21125',
      stackId: null,
    },
    personId: personStub.withName.id,
    person: personStub.withName,
    boundingBoxX1: 0,
    boundingBoxY1: 0,
    boundingBoxX2: 1,
    boundingBoxY2: 1,
    imageHeight: 1024,
    imageWidth: 1024,
    sourceType: SourceType.MachineLearning,
    faceSearch: { faceId: 'assetFaceId1', embedding: '[1, 2, 3, 4]' },
    deletedAt: new Date(),
    updatedAt: new Date('2023-01-01T00:00:00Z'),
    updateId: '0d1173e3-4d80-4d76-b41e-57d56de21125',
  }),
  primaryFace1: Object.freeze({
    id: 'assetFaceId2',
    assetId: assetStub.image.id,
    asset: assetStub.image,
    personId: personStub.primaryPerson.id,
    person: personStub.primaryPerson,
    boundingBoxX1: 0,
    boundingBoxY1: 0,
    boundingBoxX2: 1,
    boundingBoxY2: 1,
    imageHeight: 1024,
    imageWidth: 1024,
    sourceType: SourceType.MachineLearning,
    faceSearch: { faceId: 'assetFaceId2', embedding: '[1, 2, 3, 4]' },
    deletedAt: null,
    updatedAt: new Date('2023-01-01T00:00:00Z'),
    updateId: '0d1173e3-4d80-4d76-b41e-57d56de21125',
  }),
  mergeFace1: Object.freeze({
    id: 'assetFaceId3',
    assetId: assetStub.image.id,
    asset: assetStub.image,
    personId: personStub.mergePerson.id,
    person: personStub.mergePerson,
    boundingBoxX1: 0,
    boundingBoxY1: 0,
    boundingBoxX2: 1,
    boundingBoxY2: 1,
    imageHeight: 1024,
    imageWidth: 1024,
    sourceType: SourceType.MachineLearning,
    faceSearch: { faceId: 'assetFaceId3', embedding: '[1, 2, 3, 4]' },
    deletedAt: null,
    updatedAt: new Date('2023-01-01T00:00:00Z'),
    updateId: '0d1173e3-4d80-4d76-b41e-57d56de21125',
  }),
  noPerson1: Object.freeze({
    id: 'assetFaceId8',
    assetId: assetStub.image.id,
    asset: assetStub.image,
    personId: null,
    person: null,
    boundingBoxX1: 0,
    boundingBoxY1: 0,
    boundingBoxX2: 1,
    boundingBoxY2: 1,
    imageHeight: 1024,
    imageWidth: 1024,
    sourceType: SourceType.MachineLearning,
    faceSearch: { faceId: 'assetFaceId8', embedding: '[1, 2, 3, 4]' },
    deletedAt: null,
    updatedAt: new Date('2023-01-01T00:00:00Z'),
    updateId: '0d1173e3-4d80-4d76-b41e-57d56de21125',
  }),
  noPerson2: Object.freeze({
    id: 'assetFaceId9',
    assetId: assetStub.image.id,
    asset: assetStub.image,
    personId: null,
    person: null,
    boundingBoxX1: 0,
    boundingBoxY1: 0,
    boundingBoxX2: 1,
    boundingBoxY2: 1,
    imageHeight: 1024,
    imageWidth: 1024,
    sourceType: SourceType.MachineLearning,
    faceSearch: { faceId: 'assetFaceId9', embedding: '[1, 2, 3, 4]' },
    deletedAt: null,
    updatedAt: new Date('2023-01-01T00:00:00Z'),
    updateId: '0d1173e3-4d80-4d76-b41e-57d56de21125',
  }),
  fromExif1: Object.freeze({
    id: 'assetFaceId9',
    assetId: assetStub.image.id,
    asset: assetStub.image,
    personId: personStub.randomPerson.id,
    person: personStub.randomPerson,
    boundingBoxX1: 100,
    boundingBoxY1: 100,
    boundingBoxX2: 200,
    boundingBoxY2: 200,
    imageHeight: 500,
    imageWidth: 400,
    sourceType: SourceType.Exif,
    deletedAt: null,
    updatedAt: new Date('2023-01-01T00:00:00Z'),
    updateId: '0d1173e3-4d80-4d76-b41e-57d56de21125',
  }),
  fromExif2: Object.freeze({
    id: 'assetFaceId9',
    assetId: assetStub.image.id,
    asset: assetStub.image,
    personId: personStub.randomPerson.id,
    person: personStub.randomPerson,
    boundingBoxX1: 0,
    boundingBoxY1: 0,
    boundingBoxX2: 1,
    boundingBoxY2: 1,
    imageHeight: 1024,
    imageWidth: 1024,
    sourceType: SourceType.Exif,
    deletedAt: null,
    updatedAt: new Date('2023-01-01T00:00:00Z'),
    updateId: '0d1173e3-4d80-4d76-b41e-57d56de21125',
  }),
  withBirthDate: Object.freeze({
    id: 'assetFaceId10',
    assetId: assetStub.image.id,
    asset: assetStub.image,
    personId: personStub.withBirthDate.id,
    person: personStub.withBirthDate,
    boundingBoxX1: 0,
    boundingBoxY1: 0,
    boundingBoxX2: 1,
    boundingBoxY2: 1,
    imageHeight: 1024,
    imageWidth: 1024,
    sourceType: SourceType.MachineLearning,
    deletedAt: null,
    updatedAt: new Date('2023-01-01T00:00:00Z'),
    updateId: '0d1173e3-4d80-4d76-b41e-57d56de21125',
  }),
};
