/* ---------------------------------------------------------------------------


   This file is part of the ``wff'' package of NuSMV version 2.
   Copyright (C) 2011 by FBK-irst.

   NuSMV version 2 is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   NuSMV version 2 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

   For more information on NuSMV see <http://nusmv.fbk.eu>
   or email to <nusmv-users@fbk.eu>.
   Please report bugs to <nusmv-users@fbk.eu>.

   To contact the NuSMV development board, email to <nusmv@fbk.eu>.

-----------------------------------------------------------------------------*/

/*!
  \author Enrico Magnago
  \brief Public interface for Well-Formed-Formula package

  \todo: Missing description

*/



#ifndef __NUSMV_CORE_WFF_WFF_PKG_H__
#define __NUSMV_CORE_WFF_WFF_PKG_H__

#include "nusmv/core/cinit/NuSMVEnv.h"
#include "nusmv/core/wff/rewriters/WffRewriterBase.h"
#include "nusmv/core/wff/rewriters/MasterWffRewriter.h"


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

/*!
  \brief Initializes the wff package

  \sa WffPkg_quit
*/
void WffPkg_init(const NuSMVEnv_ptr env);

/*!
  \brief Deinitializes the wff package

  \sa WffPkg_init
*/
void WffPkg_quit(const NuSMVEnv_ptr env);

/*!
  \brief Register the given rewriter.

  All MasterWffRewriters created after this call will
  use the factory method to retrieve and register an instance of the walker.

*/
void WffPkg_register_rewriter(const NuSMVEnv_ptr env,
                              const typeWffRewriterCreate factory_fun);


/*!
  \brief remove the factory function from the list.

  All MasterWffRewriters created after this call will not have
  an instance of the walker generated by the given factory.
*/
boolean WffPkg_unregister_rewriter(const NuSMVEnv_ptr env,
                                   const typeWffRewriterCreate factory_fun);


#endif /* __NUSMV_CORE_WFF_WFF_PKG_H__ */
