/* ---------------------------------------------------------------------------

  This file is part of the ``cmd'' package of NuSMV version 2.
  Copyright (C) 2015 by FBK-irst.

  NuSMV version 2 is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information on NuSMV see <http://nusmv.fbk.eu>
  or email to <nusmv-users@fbk.eu>.
  Please report bugs to <nusmv-users@fbk.eu>.

  To contact the NuSMV development board, email to <nusmv@fbk.eu>.

-----------------------------------------------------------------------------*/

/*!
  \author Samuele Gallerani
  \brief The module contains an array with the couple command_name and
  command_description

  This source file contains an empty array, with cmake it is populated
  with the actual shell commands and relative description.
*/


//#include "Int.h"

#include <stdio.h>
#include <stdlib.h>

#include "nusmv/shell/cmd/cmdCmdInt.h"
#include "nusmv/shell/cmd/cmdCmd.h"
#include "nusmv/core/utils/assoc.h"


/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/

/* this is computed by scripts/create_help.py -c */
command_item command_help[] = {
/* 0 */ {"check_pslspec_bmc",
"Command check_pslspec_bmc: performs fair PSL model checking.\n"
"\n"
"usage: check_pslspec_bmc [-h] [-m | -o output-file] [-n\n"
"number | -p \"psl-expr [IN context]\" | -P \"name\"] [-g] [-1]\n"
"[-k bmc_length] [-l loopback]\\n"
"\n"
"Performs fair PSL model checking using BMC.\n"
"\n"
"A psl-expr to be checked can be specified at command line\n"
"using option -p. Alternatively, option -n can be used for\n"
"checking a particular formula in the property database. If\n"
"neither -n nor -p are used, all the PSLSPEC formulas in the\n"
"database are checked.\n"
"\n"
"Command options:\n"
"\n"
"    -m\n"
"\n"
"    Pipes the output generated by the command in processing\n"
"SPECs to the program specified by the PAGER shell variable\n"
"if defined, else through the UNIX command \"more\".\n"
"\n"
"    -o output-file\n"
"\n"
"    Writes the output generated by the command in processing\n"
"PSLSPECs to the file output-file.\n"
"\n"
"    -p \"psl-expr [IN context]\"\n"
"\n"
"    A PSL formula to be checked. context is the module\n"
"instance name which the variables in ctl-expr must be\n"
"evaluated in.\n"
"\n"
"    -n number\n"
"\n"
"    Checks the PSL property with index number in the\n"
"property database.\n"
"\n"
"    -P name\n"
"\n"
"    Checks the PSL property named name in the property\n"
"database.\n"
"\n"
"    -g While solving a problem, dumps it as a DIMACS file\n"
"whose name depends on the content of the system variable\n"
"\"bmc_dimacs_filename\". This feature is not allowed when the\n"
"option -i is used as well.\n"
"\n"
"    -1 Generates and solves a single problem instead of\n"
"iterating through 0 and bmc_length.\n"
"\n"
"    -k bmc_length\n"
"\n"
"    bmc_length is the maximum problem bound must be reached\n"
"if the option -1 is not specified. If -1 is specified,\n"
"bmc_length is the exact length of the problem to be\n"
"generated. Only natural number are valid values for this\n"
"option. If no value is given the environment variable\n"
"bmc_length is considered instead.\n"
"\n"
"    -l loopback\n"
"\n"
"    loopback value may be:\n"
"\n"
"    - a natural number in (0, bmc_length-1). Positive sign\n"
"('+') can be also used as prefix of the number. Any invalid\n"
"combination of length and loopback will be skipped during\n"
"the generation/solving process.\n"
"\n"
"    - a negative number in (-1, -bmc_length). In this case\n"
"loopback is considered a value relative to bmc_length. Any\n"
"invalid combination of length and loopback will be skipped\n"
"during the generation/solving process.\n"
"\n"
"    - the symbol 'X', which means \"no loopback\"\n"
"\n"
"    - the symbol '*', which means \"all possible loopback\n"
"from zero to bmc_length-1\""},
/* 1 */ {"check_pslspec_bmc_inc",
"Command check_pslspec_bmc_inc: performs fair PSL model\n"
"checking using incremental BMC.\n"
"\n"
"usage: check_pslspec_bmc_inc [-h] [-m | -o output-file] [-n\n"
"number | -p \"psl-expr [IN context]\" | -P \"name\"] [-1] [-k\n"
"bmc_length] [-l loopback]\\n"
"\n"
"Performs fair PSL model checking using incremental BMC.\n"
"\n"
"A psl-expr to be checked can be specified at command line\n"
"using option -p. Alternatively, option -n can be used for\n"
"checking a particular formula in the property database. If\n"
"neither -n nor -p are used, all the PSLSPEC formulas in the\n"
"database are checked.\n"
"\n"
"Command options:\n"
"\n"
"    -m\n"
"\n"
"    Pipes the output generated by the command in processing\n"
"SPECs to the program specified by the PAGER shell variable\n"
"if defined, else through the UNIX command \"more\".\n"
"\n"
"    -o output-file\n"
"\n"
"    Writes the output generated by the command in processing\n"
"PSLSPECs to the file output-file.\n"
"\n"
"    -p \"psl-expr [IN context]\"\n"
"\n"
"    A PSL formula to be checked. context is the module\n"
"instance name which the variables in ctl-expr must be\n"
"evaluated in.\n"
"\n"
"    -n number\n"
"\n"
"    Checks the PSL property with index number in the\n"
"property database.\n"
"\n"
"    -P name\n"
"\n"
"    Checks the PSL property named name in the property\n"
"database.\n"
"\n"
"    -1 Generates and solves a single problem instead of\n"
"iterating through 0 and bmc_length.\n"
"\n"
"    -k bmc_length\n"
"\n"
"    bmc_length is the maximum problem bound must be reached\n"
"if the option -1 is not specified. If -1 is specified,\n"
"bmc_length is the exact length of the problem to be\n"
"generated. Only natural number are valid values for this\n"
"option. If no value is given the environment variable\n"
"bmc_length is considered instead.\n"
"\n"
"    -l loopback\n"
"\n"
"    loopback value may be:\n"
"\n"
"    - a natural number in (0, bmc_length-1). Positive sign\n"
"('+') can be also used as prefix of the number. Any invalid\n"
"combination of length and loopback will be skipped during\n"
"the generation/solving process.\n"
"\n"
"    - a negative number in (-1, -bmc_length). In this case\n"
"loopback is considered a value relative to bmc_length. Any\n"
"invalid combination of length and loopback will be skipped\n"
"during the generation/solving process.\n"
"\n"
"    - the symbol 'X', which means \"no loopback\"\n"
"\n"
"    - the symbol '*', which means \"all possible loopback\n"
"from zero to bmc_length-1\""},
/* 2 */ {"bmc_setup",
"Command bmc_setup: builds the model in a Boolean Epression\n"
"format.\n"
"\n"
"usage: bmc_setup [-h] | [-f]\n"
"\n"
"You must call this command before use any other bmc-related\n"
"command. Only one call per session is required.\n"
"\n"
"Command options:\n"
"\n"
"    -f\n"
"\n"
"    Forces the BMC model to be built."},
/* 3 */ {"bmc_simulate",
"Command bmc_simulate: generates a trace of the model from 0\n"
"(zero) to k\n"
"\n"
"usage: bmc_simulate [-h] [-p | -v] [-r] [[-c \"constraints\"]\n"
"| [-t \"constraints\"] ] [-k steps]\n"
"\n"
"bmc_simulate does not require a specification to build the\n"
"problem, because only the model is used to build it. The\n"
"problem length is represented by the -k command parameter,\n"
"or by its default value stored in the environment variable\n"
"bmc_length.\n"
"\n"
"Command options:\n"
"\n"
"    -p\n"
"\n"
"    Prints current generated trace (only those variables\n"
"whose value changed from the previous state).\n"
"\n"
"    -v\n"
"\n"
"    Verbosely prints current generated trace (changed and\n"
"unchanged state variables).\n"
"\n"
"    -r\n"
"\n"
"    Picks a state from a set of possible future states in a\n"
"random way.\n"
"\n"
"    -c \"constraints\"\n"
"\n"
"    Performs a simulation in which computation is restricted\n"
"to states satisfying those constraints. The desired sequence\n"
"of states could not exist if such constraints were too\n"
"strong or it may happen that at some point of the simulation\n"
"a future state satisfying those constraints doesn't exist:\n"
"in that case a trace with a number of states less than steps\n"
"trace is obtained. The expression cannot contain next\n"
"operators, and is automatically shifted by one state in\n"
"order to constraint only the next steps\n"
"\n"
"    -t \"constraints\"\n"
"\n"
"    Performs a simulation in which computation is restricted\n"
"to states satisfying those constraints. The desired sequence\n"
"of states could not exist if such constraints were too\n"
"strong or it may happen that at some point of the simulation\n"
"a future state satisfying those constraints doesn't exist:\n"
"in that case a trace with a number of states less than steps\n"
"trace is obtained. The expression can contain next\n"
"operators, and is NOT automatically shifted by one state as\n"
"done with option -c\n"
"\n"
"    -k steps\n"
"\n"
"    Maximum length of the path according to the constraints.\n"
"The length of a trace could contain less than steps states:\n"
"this is the case in which simulation stops in an\n"
"intermediate step because it may not exist any future state\n"
"satisfying those constraints."},
/* 4 */ {"bmc_inc_simulate",
"Command bmc_inc_simulate: incrementally generates a trace of\n"
"the model performing a given number of steps.\n"
"\n"
"usage: bmc_inc_simulate [-h] [-p | -v] [-r] [[-c\n"
"\"constraints\"] | [-t \"constraints\"] ] [-k steps]\n"
"\n"
"bmc_inc_simulate performs incremental simulation of the\n"
"model. If no length is specified with -k command parameter,\n"
"then the number of steps of simulation to perform is taken\n"
"from the value stored in the environment variable\n"
"bmc_length.\n"
"\n"
"Command options:\n"
"\n"
"    -p\n"
"\n"
"    Prints current generated trace (only those variables\n"
"whose value changed from the previous state).\n"
"\n"
"    -v\n"
"\n"
"    Verbosely prints current generated trace (changed and\n"
"unchanged state variables).\n"
"\n"
"    -r\n"
"\n"
"    Picks a state from a set of possible future states in a\n"
"random way.\n"
"\n"
"    -i\n"
"\n"
"    Enters simulation's interactive mode.\n"
"\n"
"    -a\n"
"\n"
"    Displays all the state variables (changed and unchanged)\n"
"in the interactive session\n"
"\n"
"    -c \"constraints\"\n"
"\n"
"    Performs a simulation in which computation is restricted\n"
"to states satisfying those constraints. The desired sequence\n"
"of states could not exist if such constraints were too\n"
"strong or it may happen that at some point of the simulation\n"
"a future state satisfying those constraints doesn't exist:\n"
"in that case a trace with a number of states less than steps\n"
"trace is obtained. The expression cannot contain next\n"
"operators, and is automatically shifted by one state in\n"
"order to constraint only the next steps\n"
"\n"
"    -t \"constraints\"\n"
"\n"
"    Performs a simulation in which computation is restricted\n"
"to states satisfying those constraints. The desired sequence\n"
"of states could not exist if such constraints were too\n"
"strong or it may happen that at some point of the simulation\n"
"a future state satisfying those constraints doesn't exist:\n"
"in that case a trace with a number of states less than steps\n"
"trace is obtained. The expression can contain next\n"
"operators, and is NOT automatically shifted by one state as\n"
"done with option -c\n"
"\n"
"    -k steps\n"
"\n"
"    Maximum length of the path according to the constraints.\n"
"The length of a trace could contain less than steps states:\n"
"this is the case in which simulation stops in an\n"
"intermediate step because it may not exist any future state\n"
"satisfying those constraints."},
/* 5 */ {"bmc_pick_state",
"Command bmc_pick_state: picks a state from the set of\n"
"initial states\n"
"\n"
"usage: bmc_pick_state [-h] [-v] \\n"
"\n"
"Chooses an element from the set of initial states, and makes\n"
"it the current state (replacing the old one). The chosen\n"
"state is stored as the first state of a new trace ready to\n"
"be lengthened by steps states by the bmc_simulate or\n"
"bmc_inc_simulate commands. A constraint can be provided to\n"
"restrict the set of candidate states.\n"
"\n"
"Command options:\n"
"\n"
"    -v\n"
"\n"
"    Verbosely prints out chosen state (all state variables,\n"
"otherwise it prints out only the label t.1 of the state\n"
"chosen, where t is the number of the new trace, that is the\n"
"number of traces so far generated plus one).\n"
"\n"
"    -r\n"
"\n"
"    Randomly picks a state from the set of initial states.\n"
"\n"
"    -i\n"
"\n"
"    Enters simulation's interactive mode.\n"
"\n"
"    -a\n"
"\n"
"    Displays all the state variables (changed and unchanged)\n"
"in the interactive session\n"
"\n"
"    -c \"constraint\"\n"
"\n"
"    Uses constraint to restrict the set of initial states in\n"
"which the state has to be picked.\n"
"\n"
"    -s trace.state\n"
"\n"
"    Picks state from trace.state label. A new simulation\n"
"trace will be created by copying prefix of the source trace\n"
"up to specified state."},
/* 6 */ {"bmc_simulate_check_feasible_constraints",
"Command bmc_simulate_check_feasible_constraints: performs a\n"
"feasibility check on the list of given constraints.\n"
"Constraints that are found to be feasible can be safely\n"
"assumed not to cause deadlocks if used in the following step\n"
"of incremental simulation.\n"
"\n"
"usage: bmc_simulate_check_feasible_constraints [-h | -q] [-c\n"
"\"formula\"]*\n"
"\n"
"This command generates feasibility problems for each\n"
"constraint. Every constraint is checked against current\n"
"state and FSM's transition relation, in order to exclude the\n"
"possibility of deadlocks. Constraints found to be feasible\n"
"can be safely assumed not to cause deadlocks if used in the\n"
"following step of incremental simulation.\n"
"\n"
"Command options:\n"
"\n"
"    -q\n"
"\n"
"    Enables quiet mode. For each analyzed constraint \"0\" is\n"
"printed if the constraint is found to be unfeasible, \"1\" is\n"
"printed otherwise.\n"
"\n"
"    -c \"formula\"\n"
"\n"
"    Provide a constraint as a formula specified on the\n"
"command-line. This option can be specified multiple times,\n"
"in order to analyze a list of constraints."},
/* 7 */ {"gen_ltlspec_bmc",
"Command gen_ltlspec_bmc: dumps into one or more dimacs files\n"
"the given LTL specification, or all LTL specifications if no\n"
"formula is given. Generation and dumping parameters are the\n"
"maximum bound and the loopback values\n"
"\n"
"usage: gen_ltlspec_bmc [-h | -n idx | -p \"formula\" [IN\n"
"context] | -P \"name\"] [-k max_length] [-l loopback] [-o\n"
"filename]\n"
"\n"
"This command generates one or more problems, and dumps each\n"
"problem into a dimacs file. Each problem is related to a\n"
"specific problem bound, which increases from zero (0) to the\n"
"given maximum problem bound. In this short description\n"
"\"length\" is the bound of the problem that system is going to\n"
"dump out.\n"
"\n"
"In this context the maximum problem bound is represented by\n"
"the max_length parameter, or by its default value stored in\n"
"the environment variable bmc_length.\n"
"\n"
"Each dumped problem also depends on the loopback you can\n"
"explicitly specify by the -l option, or by its default value\n"
"stored in the environment variable bmc_loopback.\n"
"\n"
"The property to be checked may be specified using the -n\n"
"idx, the -p \"formula\" or the -P \"name\" options.\n"
"\n"
"You may specify dimacs file name by using the option -o\n"
"\"filename\", otherwise the default value stored in the\n"
"environment variable bmc_dimacs_filename will be considered.\n"
"\n"
"Command options:\n"
"\n"
"    -n index\n"
"\n"
"    index is the numeric index of a valid LTL specification\n"
"formula actually located in the properties database.\n"
"\n"
"    The validity of index value is checked out by the\n"
"system.\n"
"\n"
"    -p \"formula [IN context]\"\n"
"\n"
"    Checks the formula specified on the command-line.\n"
"\n"
"    context is the module instance name which the variables\n"
"in formula must be evaluated in.\n"
"\n"
"    -P name\n"
"\n"
"    Checks the LTLSPEC property with name name in the\n"
"property database.\n"
"\n"
"    -k max_length\n"
"\n"
"    max_length is the maximum problem bound used when\n"
"increasing problem bound starting from zero. Only natural\n"
"number are valid values for this option. If no value is\n"
"given the environment variable bmc_length value is\n"
"considered instead.\n"
"\n"
"    -l loopback\n"
"\n"
"    loopback value may be:\n"
"\n"
"    - a natural number in (0, max_length-1). Positive sign\n"
"('+') can be also used as prefix of the number. Any invalid\n"
"combination of bound and loopback will be skipped during the\n"
"generation and dumping process.\n"
"\n"
"    - a negative number in (-1, -bmc_length). In this case\n"
"loopback is considered a value relative to max_length. Any\n"
"invalid combination of bound and loopback will be skipped\n"
"during the generation process.\n"
"\n"
"    - the symbol 'X', which means \"no loopback\"\n"
"\n"
"    - the symbol '*', which means \"all possible loopback\n"
"from zero to length-1\"\n"
"\n"
"    -o filename\n"
"\n"
"    filename is the name of dumped dimacs files, without\n"
"extension.\n"
"\n"
"    If this options is not specified, variable\n"
"bmc_dimacs_filename will be considered. The file name string\n"
"may contain special symbols which will be macro-expanded to\n"
"form the real file name. Possible symbols are:\n"
"\n"
"    - @F: model name with path part\n"
"\n"
"    - @f: model name without path part\n"
"\n"
"    - @k: current problem bound\n"
"\n"
"    - @l: current loopback value\n"
"\n"
"    - @n: index of the currently processed formula in the\n"
"properties database\n"
"\n"
"    - @@: the '@' character"},
/* 8 */ {"gen_ltlspec_bmc_onepb",
"Command gen_ltlspec_bmc_onepb: dumps into one dimacs file\n"
"the problem generated for the given LTL specification, or\n"
"for all LTL specifications if no formula is explicitly\n"
"given. Generation and dumping parameters are the problem\n"
"bound and the loopback values\n"
"\n"
"usage: gen_ltlspec_bmc_onepb [-h | -n idx | -p \"formula\" [IN\n"
"context] | -P \"name\"] [-k length] [-l loopback] [-o\n"
"filename]\n"
"\n"
"As the gen_ltlspec_bmc command, but it generates and dumps\n"
"only one problem given its bound and loopback.\n"
"\n"
"Command options:\n"
"\n"
"    -n index\n"
"\n"
"    index is the numeric index of a valid LTL specification\n"
"formula actually located in the properties database.\n"
"\n"
"    The validity of index value is checked out by the\n"
"system.\n"
"\n"
"    -p \"formula [IN context]\"\n"
"\n"
"    Checks the formula specified on the command-line.\n"
"\n"
"    context is the module instance name which the variables\n"
"in formula must be evaluated in.\n"
"\n"
"    -P name\n"
"\n"
"    Checks the LTLSPEC property with name name in the\n"
"property database.\n"
"\n"
"    -k length\n"
"\n"
"    length is the single problem bound used to generate and\n"
"dump it. Only natural number are valid values for this\n"
"option. If no value is given the environment variable\n"
"bmc_length is considered instead.\n"
"\n"
"    -l loopback\n"
"\n"
"    loopback value may be:\n"
"\n"
"    - a natural number in (0, length-1). Positive sign ('+')\n"
"can be also used as prefix of the number. Any invalid\n"
"combination of length and loopback will be skipped during\n"
"the generation and dumping process.\n"
"\n"
"    - a negative number in (-1, -length). Any invalid\n"
"combination of length and loopback will be skipped during\n"
"the generation process.\n"
"\n"
"    - the symbol 'X', which means \"no loopback\"\n"
"\n"
"    - the symbol '*', which means \"all possible loopback\n"
"from zero to length-1\"\n"
"\n"
"    -o filename\n"
"\n"
"    filename is the name of the dumped dimacs file, without\n"
"extension.\n"
"\n"
"    If this options is not specified, variable\n"
"bmc_dimacs_filename will be considered. The file name string\n"
"may contain special symbols which will be macro-expanded to\n"
"form the real file name. Possible symbols are:\n"
"\n"
"    - @F: model name with path part\n"
"\n"
"    - @f: model name without path part\n"
"\n"
"    - @k: current problem bound\n"
"\n"
"    - @l: current loopback value\n"
"\n"
"    - @n: index of the currently processed formula in the\n"
"properties database\n"
"\n"
"    - @@: the '@' character"},
/* 9 */ {"check_ltlspec_bmc",
"Command check_ltlspec_bmc: checks the given LTL\n"
"specification, or all LTL specifications if no formula is\n"
"given. Checking parameters are the maximum length and the\n"
"loopback values\n"
"\n"
"usage: check_ltlspec_bmc [-h | -n idx | -p \"formula\" [IN\n"
"context] | -P \"name\"] [-k max_length] [-l loopback] [-o\n"
"filename]\n"
"\n"
"This command generates one or more problems, and calls SAT\n"
"solver for each one. Each problem is related to a specific\n"
"problem bound, which increases from zero (0) to the given\n"
"maximum problem length. Here \"length\" is the bound of the\n"
"problem that system is going to generate and/or solve.\n"
"\n"
"In this context the maximum problem bound is represented by\n"
"the -k command parameter, or by its default value stored in\n"
"the environment variable bmc_length.\n"
"\n"
"The single generated problem also depends on the \"loopback\"\n"
"parameter you can explicitly specify by the -l option, or by\n"
"its default value stored in the environment variable\n"
"bmc_loopback.\n"
"\n"
"The property to be checked may be specified using the -n\n"
"idx, the -p \"formula\" or the -P \"name\" options.\n"
"\n"
"If you need to generate a dimacs dump file of all generated\n"
"problems, you must use the option -o \"filename\".\n"
"\n"
"Command options:\n"
"\n"
"    -n index\n"
"\n"
"    index is the numeric index of a valid LTL specification\n"
"formula actually located in the properties database.\n"
"\n"
"    -p \"formula\" [IN context]\n"
"\n"
"    Checks the formula specified on the command-line.\n"
"\n"
"    context is the module instance name which the variables\n"
"in formula must be evaluated in.\n"
"\n"
"    -P name\n"
"\n"
"    Checks the LTLSPEC property with name name in the\n"
"property database.\n"
"\n"
"    -k max_length\n"
"\n"
"    max_length is the maximum problem bound must be reached.\n"
"Only natural number are valid values for this option. If no\n"
"value is given the environment variable bmc_length is\n"
"considered instead.\n"
"\n"
"    -l loopback\n"
"\n"
"    loopback value may be:\n"
"\n"
"    - a natural number in (0, max_length-1). Positive sign\n"
"('+') can be also used as prefix of the number. Any invalid\n"
"combination of length and loopback will be skipped during\n"
"the generation/solving process.\n"
"\n"
"    - a negative number in (-1, -bmc_length). In this case\n"
"loopback is considered a value relative to max_length. Any\n"
"invalid combination of length and loopback will be skipped\n"
"during the generation/solving process.\n"
"\n"
"    - the symbol 'X', which means \"no loopback\"\n"
"\n"
"    - the symbol '*', which means \"all possible loopback\n"
"from zero to length-1\"\n"
"\n"
"    -o filename\n"
"\n"
"    filename is the name of the dumped dimacs file, without\n"
"extension.\n"
"\n"
"    It may contain special symbols which will be macro-\n"
"expanded to form the real file name. Possible symbols are:\n"
"\n"
"    - @F: model name with path part\n"
"\n"
"    - @f: model name without path part\n"
"\n"
"    - @k: current problem bound\n"
"\n"
"    - @l: current loopback value\n"
"\n"
"    - @n: index of the currently processed formula in the\n"
"properties database\n"
"\n"
"    - @@: the '@' character"},
/* 10 */ {"check_ltlspec_bmc_onepb",
"Command check_ltlspec_bmc_onepb: checks the given LTL\n"
"specification, or all LTL specifications if no formula is\n"
"given. Checking parameters are the single problem bound and\n"
"the loopback values\n"
"\n"
"usage: check_ltlspec_bmc_onepb [-h | -n idx | -p \"formula\"\n"
"[IN context] | -P \"name\"] [-k length] [-l loopback] [-o\n"
"filename]\n"
"\n"
"As command check_ltlspec_bmc but it produces only one single\n"
"problem with fixed bound and loopback values, with no\n"
"iteration of the problem bound from zero to max_length.\n"
"\n"
"Command options:\n"
"\n"
"    -n index\n"
"\n"
"    index is the numeric index of a valid LTL specification\n"
"formula actually located in the properties database.\n"
"\n"
"    The validity of index value is checked out by the\n"
"system.\n"
"\n"
"    -p \"formula [IN context]\"\n"
"\n"
"    Checks the formula specified on the command-line.\n"
"\n"
"    context is the module instance name which the variables\n"
"in formula must be evaluated in.\n"
"\n"
"    -P name\n"
"\n"
"    Checks the LTLSPEC property with name name in the\n"
"property database.\n"
"\n"
"    -k length\n"
"\n"
"    length is the problem bound used when generating the\n"
"single problem. Only natural number are valid values for\n"
"this option. If no value is given the environment variable\n"
"bmc_length is considered instead.\n"
"\n"
"    -l loopback\n"
"\n"
"    loopback value may be:\n"
"\n"
"    - a natural number in (0, max_length-1). Positive sign\n"
"('+') can be also used as prefix of the number. Any invalid\n"
"combination of length and loopback will be skipped during\n"
"the generation/solving process.\n"
"\n"
"    - a negative number in (-1, -bmc_length). In this case\n"
"loopback is considered a value relative to length. Any\n"
"invalid combination of length and loopback will be skipped\n"
"during the generation/solving process.\n"
"\n"
"    - the symbol 'X', which means \"no loopback\"\n"
"\n"
"    - the symbol '*', which means \"all possible loopback\n"
"from zero to length-1\"\n"
"\n"
"    -o filename\n"
"\n"
"    filename is the name of the dumped dimacs file, without\n"
"extension.\n"
"\n"
"    It may contain special symbols which will be macro-\n"
"expanded to form the real file name. Possible symbols are:\n"
"\n"
"    - @F: model name with path part\n"
"\n"
"    - @f: model name without path part\n"
"\n"
"    - @k: current problem bound\n"
"\n"
"    - @l: current loopback value\n"
"\n"
"    - @n: index of the currently processed formula in the\n"
"properties database\n"
"\n"
"    - @@: the '@' character"},
/* 11 */ {"gen_invar_bmc",
"Command gen_invar_bmc: generates the given invariant, or all\n"
"invariants if no formula is given\n"
"\n"
"usage: gen_invar_bmc [-h | -n idx | -p \"formula\" [IN\n"
"context] | -P \"name\"] [-o filename]\n"
"\n"
"Command options:\n"
"\n"
"    -n index\n"
"\n"
"    index is the numeric index of a valid INVAR\n"
"specification formula actually located in the properties\n"
"database.\n"
"\n"
"    The validity of index value is checked out by the\n"
"system.\n"
"\n"
"    -p \"formula\" [IN context]\n"
"\n"
"    Checks the formula specified on the command-line.\n"
"\n"
"    context is the module instance name which the variables\n"
"in formula must be evaluated in.\n"
"\n"
"    -P \"name\"\n"
"\n"
"    Checks the invariant property stored in the properties\n"
"database with name \"name\"\n"
"\n"
"    -o filename\n"
"\n"
"    filename is the name of the dumped dimacs file, without\n"
"extension.\n"
"\n"
"    If you do not use this option the dimacs file name is\n"
"taken from the environment variable\n"
"bmc_invar_dimacs_filename.\n"
"\n"
"    File name may contain special symbols which will be\n"
"macro-expanded to form the real dimacs file name. Possible\n"
"symbols are:\n"
"\n"
"    - @F: model name with path part\n"
"\n"
"    - @f: model name without path part\n"
"\n"
"    - @n: index of the currently processed formula in the\n"
"properties database\n"
"\n"
"    - @@: the '@' character"},
/* 12 */ {"check_invar_bmc",
"Command check_invar_bmc: generates and solve the given\n"
"invariant, or all invariants if no formula is given\n"
"\n"
"usage: check_invar_bmc [-h | -n idx | -p \"formula\" [IN\n"
"context] | -P \"name\"] [-k max_length] [-a algorithm] [-o\n"
"filename]\n"
"\n"
"Command options:\n"
"\n"
"    -n index\n"
"\n"
"    index is the numeric index of a valid INVAR\n"
"specification formula actually located in the properties\n"
"database.\n"
"\n"
"    The validity of index value is checked out by the\n"
"system.\n"
"\n"
"    -p \"formula [IN context]\"\n"
"\n"
"    Checks the formula specified on the command-line.\n"
"\n"
"    context is the module instance name which the variables\n"
"in formula must be evaluated in.\n"
"\n"
"    -P name\n"
"\n"
"    Checks the INVARSPEC property with name name in the\n"
"property database.\n"
"\n"
"    -k max_length\n"
"\n"
"    (Use only when selected algorithm is een-sorensson). Use\n"
"to specify the maximal deepth to be reached by the een-\n"
"sorensson invariant checking algorithm. If not specified,\n"
"the value assigned to the system variable bmc_length is\n"
"taken.\n"
"\n"
"    -a algorithm\n"
"\n"
"    Uses the specified algorithm to solve the invariant. If\n"
"used, this option will override system variable\n"
"bmc_invar_alg. At the moment, possible values are: \"classic\"\n"
"(aka k-induction with k=1), \"een-sorensson\".\n"
"\n"
"    -e\n"
"\n"
"    Uses an additional step clause for algorithm \"een-\n"
"sorensson\".\n"
"\n"
"    filename is the name of the dumped dimacs file, without\n"
"extension.\n"
"\n"
"    It may contain special symbols which will be macro-\n"
"expanded to form the real file name. Possible symbols are:\n"
"\n"
"    - @F: model name with path part\n"
"\n"
"    - @f: model name without path part\n"
"\n"
"    - @n: index of the currently processed formula in the\n"
"properties database\n"
"\n"
"    - @@: the '@' character"},
/* 13 */ {"check_ltlspec_bmc_inc",
"Command check_ltlspec_bmc_inc: checks the given LTL\n"
"specification, or all LTL specifications if no formula is\n"
"given, using incremental algorithms. Checking parameters are\n"
"the maximum length and the loopback values\n"
"\n"
"usage: check_ltlspec_bmc_inc [-h | -n idx | -p \"formula\" [IN\n"
"context] | -P \"name\"] [-k max_length] [-l loopback]\n"
"\n"
"This command generates one or more problems, and calls\n"
"(incremental) SAT solver for each one. Each problem is\n"
"related to a specific problem bound, which increases from\n"
"zero (0) to the given maximum problem length. Here \"length\"\n"
"is the bound of the problem that system is going to generate\n"
"and/or solve.\n"
"\n"
"In this context the maximum problem bound is represented by\n"
"the -k command parameter, or by its default value stored in\n"
"the environment variable bmc_length.\n"
"\n"
"The single generated problem also depends on the \"loopback\"\n"
"parameter you can explicitly specify by the -l option, or by\n"
"its default value stored in the environment variable\n"
"bmc_loopback.\n"
"\n"
"The property to be checked may be specified using the -n\n"
"idx, the -p \"formula\" or the -P \"name\" options.\n"
"\n"
"Command options:\n"
"\n"
"    -n index\n"
"\n"
"    index is the numeric index of a valid LTL specification\n"
"formula actually located in the properties database.\n"
"\n"
"    -p \"formula\" [IN context]\n"
"\n"
"    Checks the formula specified on the command-line.\n"
"\n"
"    context is the module instance name which the variables\n"
"in formula must be evaluated in.\n"
"\n"
"    -P name\n"
"\n"
"    Checks the LTLSPEC property with name name in the\n"
"property database.\n"
"\n"
"    -k max_length\n"
"\n"
"    max_length is the maximum problem bound must be reached.\n"
"Only natural number are valid values for this option. If no\n"
"value is given the environment variable bmc_length is\n"
"considered instead.\n"
"\n"
"    -l loopback\n"
"\n"
"    loopback value may be:\n"
"\n"
"    - a natural number in (0, max_length-1). Positive sign\n"
"('+') can be also used as prefix of the number. Any invalid\n"
"combination of length and loopback will be skipped during\n"
"the generation/solving process.\n"
"\n"
"    - a negative number in (-1, -bmc_length). In this case\n"
"loopback is considered a value relative to max_length. Any\n"
"invalid combination of length and loopback will be skipped\n"
"during the generation/solving process.\n"
"\n"
"    - the symbol 'X', which means \"no loopback\"\n"
"\n"
"    - the symbol '*', which means \"all possible loopback\n"
"from zero to length-1\""},
/* 14 */ {"check_invar_bmc_inc",
"Command check_invar_bmc_inc: generates and solve the given\n"
"invariant, or all invariants if no formula is given\n"
"\n"
"usage: check_invar_bmc_inc [-h | -n idx | -p \"formula\" [IN\n"
"context] | -P \"name\"] [-k max_length] [-a algorithm] [-s\n"
"strategy]\n"
"\n"
"Command options:\n"
"\n"
"    -n index\n"
"\n"
"    index is the numeric index of a valid INVAR\n"
"specification formula actually located in the properties\n"
"database.\n"
"\n"
"    The validity of index value is checked out by the\n"
"system.\n"
"\n"
"    -p \"formula [IN context]\"\n"
"\n"
"    Checks the formula specified on the command-line.\n"
"\n"
"    context is the module instance name which the variables\n"
"in formula must be evaluated in.\n"
"\n"
"    -P name\n"
"\n"
"    Checks the INVARSPEC property with name name in the\n"
"property database.\n"
"\n"
"    -k max_length\n"
"\n"
"    Use to specify the maximal depth to be reached by the\n"
"incremental invariant checking algorithm. If not specified,\n"
"the value assigned to the system variable bmc_length is\n"
"taken.\n"
"\n"
"    -a algorithm\n"
"\n"
"    Use to specify incremental invariant checking algorithm.\n"
"Currently this can be one of the following values: dual,\n"
"zigzag, falsification.\n"
"\n"
"    -s strategy\n"
"\n"
"    Use to specify closure strategy (this currenly applies\n"
"to dual algorithm only). This can be one of the following\n"
"values: backward, forward."},
/* 15 */ {"check_pslspec_sbmc",
"Command check_pslspec_sbmc: performs fair PSL model\n"
"checking.\n"
"\n"
"usage: check_pslspec_sbmc [-h] [-m | -o output-file] [-n\n"
"number | -p \"psl-expr [IN context]\" | -P \"name\"] [-g] [-1]\n"
"[-k bmc_length] [-l loopback]\\n"
"\n"
"Performs fair PSL model checking using SBMC.\n"
"\n"
"A psl-expr to be checked can be specified at command line\n"
"using option -p. Alternatively, option -n can be used for\n"
"checking a particular formula in the property database. If\n"
"neither -n nor -p are used, all the PSLSPEC formulas in the\n"
"database are checked.\n"
"\n"
"Command options:\n"
"\n"
"    -m\n"
"\n"
"    Pipes the output generated by the command in processing\n"
"SPECs to the program specified by the PAGER shell variable\n"
"if defined, else through the UNIX command \"more\".\n"
"\n"
"    -o output-file\n"
"\n"
"    Writes the output generated by the command in processing\n"
"PSLSPECs to the file output-file.\n"
"\n"
"    -p \"psl-expr [IN context]\"\n"
"\n"
"    A PSL formula to be checked. context is the module\n"
"instance name which the variables in ctl-expr must be\n"
"evaluated in.\n"
"\n"
"    -n number\n"
"\n"
"    Checks the PSL property with index number in the\n"
"property database.\n"
"\n"
"    -P name\n"
"\n"
"    Checks the PSL property named name in the property\n"
"database.\n"
"\n"
"    -g While solving a problem, dumps it as a DIMACS file\n"
"whose name depends on the content of the system variable\n"
"\"bmc_dimacs_filename\". This feature is not allowed when the\n"
"option -i is used as well.\n"
"\n"
"    -1 Generates and solves a single problem instead of\n"
"iterating through 0 and bmc_length.\n"
"\n"
"    -k bmc_length\n"
"\n"
"    bmc_length is the maximum problem bound must be reached\n"
"if the option -1 is not specified. If -1 is specified,\n"
"bmc_length is the exact length of the problem to be\n"
"generated. Only natural number are valid values for this\n"
"option. If no value is given the environment variable\n"
"bmc_length is considered instead.\n"
"\n"
"    -l loopback\n"
"\n"
"    loopback value may be:\n"
"\n"
"    - a natural number in (0, bmc_length-1). Positive sign\n"
"('+') can be also used as prefix of the number. Any invalid\n"
"combination of length and loopback will be skipped during\n"
"the generation/solving process.\n"
"\n"
"    - a negative number in (-1, -bmc_length). In this case\n"
"loopback is considered a value relative to bmc_length. Any\n"
"invalid combination of length and loopback will be skipped\n"
"during the generation/solving process.\n"
"\n"
"    - the symbol 'X', which means \"no loopback\"\n"
"\n"
"    - the symbol '*', which means \"all possible loopback\n"
"from zero to bmc_length-1\""},
/* 16 */ {"check_pslspec_sbmc_inc",
"Command check_pslspec_sbmc_inc: performs fair PSL model\n"
"checking.\n"
"\n"
"usage: check_pslspec_sbmc_inc [-h] [-m | -o output-file] [-n\n"
"number | -p \"psl-expr [IN context]\" | -P \"name\"] [-1] [-k\n"
"bmc_length] [-l loopback]\\n"
"\n"
"Performs fair PSL model checking using SBMC.\n"
"\n"
"A psl-expr to be checked can be specified at command line\n"
"using option -p. Alternatively, option -n can be used for\n"
"checking a particular formula in the property database. If\n"
"neither -n nor -p are used, all the PSLSPEC formulas in the\n"
"database are checked.\n"
"\n"
"Command options:\n"
"\n"
"    -m\n"
"\n"
"    Pipes the output generated by the command in processing\n"
"SPECs to the program specified by the PAGER shell variable\n"
"if defined, else through the UNIX command \"more\".\n"
"\n"
"    -o output-file\n"
"\n"
"    Writes the output generated by the command in processing\n"
"PSLSPECs to the file output-file.\n"
"\n"
"    -p \"psl-expr [IN context]\"\n"
"\n"
"    A PSL formula to be checked. context is the module\n"
"instance name which the variables in ctl-expr must be\n"
"evaluated in.\n"
"\n"
"    -n number\n"
"\n"
"    Checks the PSL property with index number in the\n"
"property database.\n"
"\n"
"    -P name\n"
"\n"
"    Checks the PSL property named name in the property\n"
"database.\n"
"\n"
"    -1 Generates and solves a single problem instead of\n"
"iterating through 0 and bmc_length.\n"
"\n"
"    -k bmc_length\n"
"\n"
"    bmc_length is the maximum problem bound must be reached\n"
"if the option -1 is not specified. If -1 is specified,\n"
"bmc_length is the exact length of the problem to be\n"
"generated. Only natural number are valid values for this\n"
"option. If no value is given the environment variable\n"
"bmc_length is considered instead.\n"
"\n"
"    -l loopback\n"
"\n"
"    loopback value may be:\n"
"\n"
"    - a natural number in (0, bmc_length-1). Positive sign\n"
"('+') can be also used as prefix of the number. Any invalid\n"
"combination of length and loopback will be skipped during\n"
"the generation/solving process.\n"
"\n"
"    - a negative number in (-1, -bmc_length). In this case\n"
"loopback is considered a value relative to bmc_length. Any\n"
"invalid combination of length and loopback will be skipped\n"
"during the generation/solving process.\n"
"\n"
"    - the symbol 'X', which means \"no loopback\"\n"
"\n"
"    - the symbol '*', which means \"all possible loopback\n"
"from zero to bmc_length-1\""},
/* 17 */ {"check_ltlspec_sbmc",
"Command check_ltlspec_sbmc: finds error up to depth k\n"
"\n"
"usage: check_ltlspec_sbmc [-h | -n idx | -p \"formula\" [IN\n"
"context] | -P \"name\"] [-k max_length] [-l loopback] [-1] [-o\n"
"filename]\n"
"\n"
"This command generates one or more problems, and calls SAT\n"
"solver for each one. Each problem is related to a specific\n"
"problem bound, which increases from zero (0) to the given\n"
"maximum problem length. Here \"length\" is the bound of the\n"
"problem that system is going to generate and/or solve.\n"
"\n"
"In this context the maximum problem bound is represented by\n"
"the -k command parameter, or by its default value stored in\n"
"the environment variable bmc_length.\n"
"\n"
"The single generated problem also depends on the \"loopback\"\n"
"parameter you can explicitly specify by the -l option, or by\n"
"its default value stored in the environment variable\n"
"bmc_loopback.\n"
"\n"
"The property to be checked may be specified using the -n idx\n"
"or the -p \"formula\" options.\n"
"\n"
"If you need to generate a dimacs dump file of all generated\n"
"problems, you must use the option -o \"filename\".\n"
"\n"
"Command options:\n"
"\n"
"    -n index\n"
"\n"
"    index is the numeric index of a valid LTL specification\n"
"formula actually located in the properties database.\n"
"\n"
"    -p \"formula\" [IN context]\n"
"\n"
"    Checks the formula specified on the command-line.\n"
"\n"
"    context is the module instance name which the variables\n"
"in formula must be evaluated in.\n"
"\n"
"    -P name\n"
"\n"
"    Checks the LTLSPEC property with name name in the\n"
"property database.\n"
"\n"
"    -k max_length\n"
"\n"
"    max_length is the maximum problem bound must be reached.\n"
"Only natural number are valid values for this option. If no\n"
"value is given the environment variable bmc_length is\n"
"considered instead.\n"
"\n"
"    -l loopback\n"
"\n"
"    loopback value may be:\n"
"\n"
"    - a natural number in (0, max_length-1). Positive sign\n"
"('+') can be also used as prefix of the number. Any invalid\n"
"combination of length and loopback will be skipped during\n"
"the generation/solving process.\n"
"\n"
"    - a negative number in (-1, -bmc_length). In this case\n"
"loopback is considered a value relative to max_length. Any\n"
"invalid combination of length and loopback will be skipped\n"
"during the generation/solving process.\n"
"\n"
"    - the symbol 'X', which means \"no loopback\"\n"
"\n"
"    - the symbol '*', which means \"all possible loopback\n"
"from zero to length-1\"\n"
"\n"
"    -1\n"
"\n"
"    Generates and solves a single problem with length k\n"
"\n"
"    -o filename\n"
"\n"
"    filename is the name of the dumped dimacs file. It may\n"
"contain special symbols which will be macro-expanded to form\n"
"the real file name. Possible symbols are:\n"
"\n"
"    - @F: model name with path part\n"
"\n"
"    - @f: model name without path part\n"
"\n"
"    - @k: current problem bound\n"
"\n"
"    - @l: current loopback value\n"
"\n"
"    - @n: index of the currently processed formula in the\n"
"properties database\n"
"\n"
"    - @@: the '@' character\n"
"\n"
"For further information about this implementation see: T.\n"
"Latvala, A. Biere, K. Heljanko, and T. Junttila. Simple is\n"
"Better: Efficient Bounded Model Checking for Past LTL. In:\n"
"R. Cousot (ed.), Verification, Model Checking, and Abstract\n"
"Interpretation, 6th International Conference VMCAI 2005,\n"
"Paris, France, Volume 3385 of LNCS, pp. 380-395, Springer,\n"
"2005. Copyright (C) Springer-Verlag."},
/* 18 */ {"gen_ltlspec_sbmc",
"Command gen_ltlspec_sbmc: dumps into one or more dimacs\n"
"files the given LTL specification, or all LTL specifications\n"
"if no formula is given. Generation and dumping parameters\n"
"are the maximum bound and the loopback values. Uses Kepa's\n"
"and Timo's method for doing bmc.\n"
"\n"
"usage: gen_ltlspec_sbmc [-h | -n idx | -p \"formula\" [IN\n"
"context] | -P \"name\"] [-k max_length] [-l loopback] [-1] [-o\n"
"filename]\n"
"\n"
"This command generates one or more problems, and dumps each\n"
"problem into a dimacs file. Each problem is related to a\n"
"specific problem bound, which increases from zero (0) to the\n"
"given maximum problem bound. In this short description\n"
"\"length\" is the bound of the problem that system is going to\n"
"dump out. Uses Kepa's and Timo's method for doing bmc.\n"
"\n"
"In this context the maximum problem bound is represented by\n"
"the max_length parameter, or by its default value stored in\n"
"the environment variable bmc_length.\n"
"\n"
"Each dumped problem also depends on the loopback you can\n"
"explicitly specify by the -l option, or by its default value\n"
"stored in the environment variable bmc_loopback.\n"
"\n"
"The property to be checked may be specified using the -n idx\n"
"or the -p \"formula\" options.\n"
"\n"
"You may specify dimacs file name by using the option -o\n"
"\"filename\", otherwise the default value stored in the\n"
"environment variable bmc_dimacs_filename will be considered.\n"
"\n"
"Command options:\n"
"\n"
"    -n index\n"
"\n"
"    index is the numeric index of a valid LTL specification\n"
"formula actually located in the properties database.\n"
"\n"
"    -p \"formula\" [IN context]\n"
"\n"
"    Checks the formula specified on the command-line.\n"
"\n"
"    context is the module instance name which the variables\n"
"in formula must be evaluated in.\n"
"\n"
"    -P name\n"
"\n"
"    Checks the LTLSPEC property with name name in the\n"
"property database.\n"
"\n"
"    -k max_length\n"
"\n"
"    max_length is the maximum problem bound must be reached.\n"
"Only natural number are valid values for this option. If no\n"
"value is given the environment variable bmc_length is\n"
"considered instead.\n"
"\n"
"    -l loopback\n"
"\n"
"    loopback value may be:\n"
"\n"
"    - a natural number in (0, max_length-1). Positive sign\n"
"('+') can be also used as prefix of the number. Any invalid\n"
"combination of length and loopback will be skipped during\n"
"the generation/solving process.\n"
"\n"
"    - a negative number in (-1, -bmc_length). In this case\n"
"loopback is considered a value relative to max_length. Any\n"
"invalid combination of length and loopback will be skipped\n"
"during the generation/solving process.\n"
"\n"
"    - the symbol 'X', which means \"no loopback\"\n"
"\n"
"    - the symbol '*', which means \"all possible loopback\n"
"from zero to length-1\"\n"
"\n"
"    -1\n"
"\n"
"    Generates a single problem with length k\n"
"\n"
"    -o filename\n"
"\n"
"    filename is the name of the dumped dimacs file. It may\n"
"contain special symbols which will be macro-expanded to form\n"
"the real file name. Possible symbols are:\n"
"\n"
"    - @F: model name with path part\n"
"\n"
"    - @f: model name without path part\n"
"\n"
"    - @k: current problem bound\n"
"\n"
"    - @l: current loopback value\n"
"\n"
"    - @n: index of the currently processed formula in the\n"
"properties database\n"
"\n"
"    - @@: the '@' character\n"
"\n"
"For further information about this implementation see: T.\n"
"Latvala, A. Biere, K. Heljanko, and T. Junttila. Simple is\n"
"Better: Efficient Bounded Model Checking for Past LTL. In:\n"
"R. Cousot (ed.), Verification, Model Checking, and Abstract\n"
"Interpretation, 6th International Conference VMCAI 2005,\n"
"Paris, France, Volume 3385 of LNCS, pp. 380-395, Springer,\n"
"2005. Copyright (C) Springer-Verlag."},
/* 19 */ {"check_ltlspec_sbmc_inc",
"Command check_ltlspec_sbmc_inc: incremental SBMC LTL model\n"
"checking\n"
"\n"
"usage: check_ltlspec_sbmc_inc [-h | -n idx | -p \"formula\"\n"
"[IN context] | -P \"name\"] [-k max_length] [-c] [-N]\n"
"\n"
"This command generates one or more problems, and calls SAT\n"
"solver for each one. Each problem is related to a specific\n"
"problem bound, which increases from zero (0) to the given\n"
"maximum problem length. Here \"length\" is the bound of the\n"
"problem that system is going to generate and/or solve.\n"
"\n"
"In this context the maximum problem bound is represented by\n"
"the -k command parameter, or by its default value stored in\n"
"the environment variable bmc_length.\n"
"\n"
"The property to be checked may be specified using the -n\n"
"idx, -p \"formula\", or -P \"property_name\" options.\n"
"\n"
"Completeness check, although slower, can be used to\n"
"determine whether the property holds.\n"
"\n"
"Command options:\n"
"\n"
"    -n index\n"
"\n"
"    index is the numeric index of a valid LTL specification\n"
"formula actually located in the properties database.\n"
"\n"
"    -p \"formula\" [IN context]\n"
"\n"
"    Checks the formula specified on the command-line.\n"
"\n"
"    context is the module instance name which the variables\n"
"in formula must be evaluated in.\n"
"\n"
"    -P name\n"
"\n"
"    Checks the LTLSPEC property with name name in the\n"
"property database.\n"
"\n"
"    -k max_length\n"
"\n"
"    max_length is the maximum problem bound must be reached.\n"
"Only natural number are valid values for this option. If no\n"
"value is given the environment variable bmc_length is\n"
"considered instead.\n"
"\n"
"    -c\n"
"\n"
"    Performs completeness check at every step. This can be\n"
"effectively used to determine whether a property holds.\n"
"\n"
"    -N\n"
"\n"
"    Does not perform virtual unrolling.\n"
"\n"
"For further information about this implementation see: T.\n"
"Latvala, A. Biere, K. Heljanko, and T. Junttila. Simple is\n"
"Better: Efficient Bounded Model Checking for Past LTL. In:\n"
"R. Cousot (ed.), Verification, Model Checking, and Abstract\n"
"Interpretation, 6th International Conference VMCAI 2005,\n"
"Paris, France, Volume 3385 of LNCS, pp. 380-395, Springer,\n"
"2005. Copyright (C) Springer-Verlag."},
/* 20 */ {"reset",
"Command reset: resets the whole system.\n"
"\n"
"usage: reset [-h]\n"
"\n"
"Resets the whole system, in order to read in another model\n"
"and to perform verification on it.\n"
"\n"
"Command options:\n"
"\n"
"    -h\n"
"\n"
"    Prints the command usage."},
/* 21 */ {"print_usage",
"Command print_usage: prints processor and BDD statistics.\n"
"\n"
"usage: print_usage [-h]\n"
"\n"
"Prints a formatted dump of processor-specific usage\n"
"statistics, and BDD usage statistics. For Berkeley Unix,\n"
"this includes all of the information in the getrusage()\n"
"structure.\n"
"\n"
"Command options:\n"
"\n"
"    -h\n"
"\n"
"    Prints the command usage."},
/* 22 */ {"time",
"Command time: provides a simple CPU elapsed time value\n"
"\n"
"usage: time [-h]\n"
"\n"
"Prints the processor time used since the last invocation of\n"
"the \"time\" command, and the total processor time used\n"
"since NuSMV was started."},
/* 23 */ {"echo",
"Command echo: merely echoes the arguments. File redirection\n"
"is allowed.\n"
"\n"
"usage: echo [-h] [-2] [-n] [-o filename [-a]] <args>\n"
"\n"
"Echoes its arguments to standard output.\n"
"\n"
"Command options:\n"
"\n"
"    -2\n"
"\n"
"    Redirects output to the standard error instead of the\n"
"standard output. This cannot be used in combination with -o.\n"
"\n"
"    -n\n"
"\n"
"    Does not output the trailing newline.\n"
"\n"
"    -o filename\n"
"\n"
"    Echoes on the specified file instead of on the standard\n"
"output.\n"
"\n"
"    -a\n"
"\n"
"    When used with option -o, appends the output to the\n"
"specified file instead of overwriting it."},
/* 24 */ {"_memory_profile",
"Command _memory_profile: it shows the amount of memory used\n"
"by every package.\n"
"\n"
"usage: _memory_profile [-f <filename>] [-h] [-p] [-u\n"
"<units>]\n"
"\n"
"This command intregrates the output from purify with a\n"
"function map generated by a perlscript plus another\n"
"perlscript to generate a memory profile of NuSMV.\n"
"\n"
"This command relies on the output of purify to a file to\n"
"call the script \"memoryaccount\" and produces a summary of\n"
"how much memory has been allocated by each package. Although\n"
"this command may appear simple it requires the interaction\n"
"of two scripts and three files, so special care should be\n"
"taken when attempting to modify it.\n"
"\n"
"Here is the way it works. The code in this command is\n"
"conditionally compiled depending on the definition of the\n"
"symbol PURIFY. If the symbol is not defined, the program\n"
"prints a message notifying that the command is not operative\n"
"in this executable. If PURIFY has been defined, there are\n"
"certain things that are assumed. The executable has been\n"
"linked with purify. The output of purify is being redirected\n"
"to a file with name purify.log. The perl script\n"
"memoryaccount is in $NUSMV_LIBRARY_PATH/common/share and it\n"
"is executable. There exists a file whose name is .fmap,\n"
"located in the same directory which script memoryaccount is\n"
"located in. This file maps function names to packages which\n"
"contain them.\n"
"\n"
"The command then calls purify_all_inuse() to force purify to\n"
"dump to the file purify.log all information about the memory\n"
"that is currently visible to the program. This memory is not\n"
"the total memory allocated by the program since there may be\n"
"leaked memory that is no longer accessible. A temporary file\n"
"is created and the script memoryaccount is called to analyze\n"
"the file purify.log and write in the temporary file the\n"
"memory profile obtained from it. Once the script is done,\n"
"the temporary file is dumped to outstream and deleted.\n"
"\n"
"Since most of the computation in this command is done by the\n"
"pearlscript memoryaccount, for more information please refer\n"
"to the message printed when the script is invoked with the\n"
"option -h.\n"
"\n"
"Command options:\n"
"\n"
"    -f <filename>\n"
"\n"
"    File to read the dump from. The default is purify.log.\n"
"This option should be used if and only if the option -log-\n"
"file has been used at the linking stage when building the\n"
"executable.\n"
"\n"
"    -p\n"
"\n"
"    Prints also the packages that did not allocated any\n"
"detectable memory\n"
"\n"
"    -u <units>\n"
"\n"
"    Units to print the memory usage in. It may be \"b\" for\n"
"bytes, \"k\" for kilobytes, \"m\" for megabytes and \"g\" for\n"
"gigabytes. The default is bytes."},
/* 25 */ {"quit",
"Command quit: exits NuSMV\n"
"\n"
"usage: quit [-h] [-s] [-x]\n"
"\n"
"Stops the program. Does not save the current network before\n"
"exiting.\n"
"\n"
"Command options:\n"
"\n"
"    -s\n"
"\n"
"    Frees all the used memory before quitting. This is\n"
"slower, and it is used for finding memory leaks.\n"
"\n"
"    -x\n"
"\n"
"    Leave immediately. Skip all the cleanup code, leave it\n"
"to the OS. This can save quite a long time."},
/* 26 */ {"usage",
"Command usage: provides a dump of process statistics\n"
"\n"
"usage: usage [-h]\n"
"\n"
"Prints a formatted dump of processor-specific usage\n"
"statistics. For Berkeley Unix, this includes all of the\n"
"information in the getrusage() structure."},
/* 27 */ {"which",
"Command which: looks for a file called \"file_name\"\n"
"\n"
"usage: which [-h] <file_name>\n"
"\n"
"Looks for a file in a set of directories which includes the\n"
"current directory as well as those in the NuSMV path. If it\n"
"finds the specified file, it reports the found file's path.\n"
"The searching path is specified through the \"set open_path\"\n"
"command in \".nusmvrc\".\n"
"\n"
"Command options:\n"
"\n"
"    <file_name>\n"
"\n"
"    File to be searched"},
/* 28 */ {"history",
"Command history: list previous commands and their event\n"
"numbers\n"
"\n"
"usage: history [-h] [<num>]\n"
"\n"
"Lists previous commands and their event numbers. This is a\n"
"UNIX-like history mechanism inside the NuSMV shell.\n"
"\n"
"Command options:\n"
"\n"
"    <num>\n"
"\n"
"    Lists the last <num> events. Lists the last 30 events if\n"
"<num> is not specified.\n"
"\n"
"History Substitution:\n"
"\n"
"The history substitution mechanism is a simpler version of\n"
"the csh history substitution mechanism. It enables you to\n"
"reuse words from previously typed commands.\n"
"\n"
"The default history substitution character is the `%' (`!'\n"
"is default for shell escapes, and `#' marks the beginning of\n"
"a comment). This can be changed using the \"set\" command. In\n"
"this description '%' is used as the history_char. The `%'\n"
"can appear anywhere in a line. A line containing a history\n"
"substitution is echoed to the screen after the substitution\n"
"takes place. `%' can be preceded by a `\\' in order to\n"
"escape the substitution, for example, to enter a `%' into an\n"
"alias or to set the prompt.\n"
"\n"
"Each valid line typed at the prompt is saved. If the\n"
"\"history\" variable is set (see help page for \"set\"), each\n"
"line is also echoed to the history file. You can use the\n"
"\"history\" command to list the previously typed commands.\n"
"\n"
"Substitutions:\n"
"\n"
"At any point in a line these history substitutions are\n"
"available.\n"
"\n"
"    %:0\n"
"\n"
"    Initial word of last command.\n"
"\n"
"    %:n\n"
"\n"
"    n-th argument of last command.\n"
"\n"
"    %$\n"
"\n"
"    Last argument of last command.\n"
"\n"
"    %*\n"
"\n"
"    All but initial word of last command.\n"
"\n"
"    %%\n"
"\n"
"    Last command.\n"
"\n"
"    %stuf\n"
"\n"
"    Last command beginning with \"stuf\".\n"
"\n"
"    %n\n"
"\n"
"    Repeat the n-th command.\n"
"\n"
"    %-n\n"
"\n"
"    Repeat the n-th previous command.\n"
"\n"
"    ^old^new\n"
"\n"
"    Replace \"old\" with \"new\" in previous command. Trailing\n"
"spaces are significant during substitution. Initial spaces\n"
"are not significant."},
/* 29 */ {"alias",
"Command alias: provides an alias for a command\n"
"\n"
"usage: alias [-h] [<name> [<string>]]\n"
"\n"
"The \"alias\" command, if given no arguments, will print the\n"
"definition of all current aliases.\n"
"\n"
"Given a single argument, it will print the definition of\n"
"that alias (if any). Given two arguments, the keyword <name>\n"
"becomes an alias for the command string <string>, replacing\n"
"any other alias with the same name.\n"
"\n"
"    Command options:\n"
"\n"
"    <name>\n"
"\n"
"    Alias\n"
"\n"
"    <string>\n"
"\n"
"    Command string\n"
"\n"
"It is possible to create aliases that take arguments by\n"
"using the history substitution mechanism. To protect the\n"
"history substitution character `%' from immediate expansion,\n"
"it must be preceded by a `\\' when entering the alias.\n"
"\n"
"For example:\n"
"\n"
"NuSMV> alias read \"read_model -i \\%:1.smv ; set\n"
"input_order_file \\%:1.ord\" NuSMV> read short\n"
"\n"
"will create an alias `read', execute \"read_model -i\n"
"short.smv; set input_order_file short.ord\".\n"
"\n"
"And again:\n"
"\n"
"NuSMV> alias echo2 \"echo Hi ; echo \\%* !\"\n"
"\n"
"NuSMV> echo2 happy birthday\n"
"\n"
"will print:\n"
"\n"
"Hi\n"
"\n"
"happy birthday !\n"
"\n"
"CAVEAT: Currently there is no check to see if there is a\n"
"circular dependency in the alias definition. e.g.\n"
"\n"
"NuSMV> alias foo \"echo print_bdd_stats; foo\"\n"
"\n"
"creates an alias which refers to itself. Executing the\n"
"command foo will result an infinite loop during which the\n"
"command print_bdd_stats will be executed."},
/* 30 */ {"unalias",
"Command unalias: removes the definition of an alias.\n"
"\n"
"usage: unalias [-h] <alias-names>\n"
"\n"
"Removes the definition of an alias specified via the alias\n"
"command.\n"
"\n"
"Command options:\n"
"\n"
"    <alias-names>\n"
"\n"
"    Aliases to be removed"},
/* 31 */ {"help",
"Command help: provides on-line information on commands\n"
"\n"
"usage: help [-h] [-a] [-p] [<command>]\n"
"\n"
"If invoked with no arguments \"help\" prints the list of all\n"
"commands known to the command interpreter. If a command name\n"
"is given, detailed information for that command will be\n"
"provided.\n"
"\n"
"Command options:\n"
"\n"
"    -a\n"
"\n"
"    Provides a list of all internal commands, whose names\n"
"begin with the underscore character ('_') by convention.\n"
"\n"
"    -p\n"
"\n"
"    Disables the use of a pager like 'more' or any set in\n"
"environment variable 'PAGER'."},
/* 32 */ {"_print_tool_compilation_mode",
"Command _print_tool_compilation_mode: print whether the tool\n"
"has been built in debug mode or in release mode.\n"
"\n"
"usage: _print_tool_compilation_mode [-h]\n"
"\n"
"If invoked with no arguments \"_print_tool_compilation_mode\"\n"
"prints whether the tool has been built in debug mode or in\n"
"release mode.\n"
"\n"
"Command options:\n"
"\n"
"    -h\n"
"\n"
"    Shows the command help."},
/* 33 */ {"source",
"Command source: executes a sequence of commands from a file\n"
"\n"
"usage: source [-h] [-p] [-s] [-x] <file> [<args>]\n"
"\n"
"Reads and executes commands from a file.\n"
"\n"
"Command options:\n"
"\n"
"    -p\n"
"\n"
"    Prints a prompt before reading each command.\n"
"\n"
"    -s\n"
"\n"
"    Silently ignores an attempt to execute commands from a\n"
"nonexistent file.\n"
"\n"
"    -x\n"
"\n"
"    Echoes each command before it is executed.\n"
"\n"
"    <file>\n"
"\n"
"    File name\n"
"\n"
"Arguments on the command line after the filename are\n"
"remembered but not evaluated. Commands in the script file\n"
"can then refer to these arguments using the history\n"
"substitution mechanism.\n"
"\n"
"EXAMPLE:\n"
"\n"
"Contents of test.scr:\n"
"\n"
"read_model -i %:2\n"
"\n"
"flatten_hierarchy\n"
"\n"
"build_variables\n"
"\n"
"build_model\n"
"\n"
"Typing \"source test.scr short.smv\" on the command line will\n"
"execute the sequence\n"
"\n"
"read_model -i short.smv\n"
"\n"
"flatten_hierarchy\n"
"\n"
"build_variables\n"
"\n"
"build_model\n"
"\n"
"(In this case %:0 gets \"source\", %:1 gets \"test.scr\", and\n"
"%:2 gets \"short.smv\".) If you type \"alias st source\n"
"test.scr\" and then type \"st short.smv bozo\", you will\n"
"execute\n"
"\n"
"read_model -i bozo\n"
"\n"
"flatten_hierarchy\n"
"\n"
"build_variables\n"
"\n"
"build_model\n"
"\n"
"because \"bozo\" was the second argument on the last command\n"
"line typed. In other words, command substitution in a script\n"
"file depends on how the script file was invoked. Switches\n"
"passed to a command are also counted as positional\n"
"parameters. Therefore, if you type \"st -x short.smv bozo\",\n"
"you will execute\n"
"\n"
"read_model -i short.smv\n"
"\n"
"flatten_hierarchy\n"
"\n"
"build_variables\n"
"\n"
"build_model\n"
"\n"
"To pass the \"-x\" switch (or any other switch) to \"source\"\n"
"when the script uses positional parameters, you may define\n"
"an alias. For instance, \"alias srcx source -x\".\n"
"\n"
"returns -3 if an error occurs and the flag\n"
"'on_failure_script_quits' is set."},
/* 34 */ {"_show_help",
"Command _show_help: provides on-line information for all\n"
"commands\n"
"\n"
"usage: _show_help [-f] [-h] [<command>]\n"
"\n"
"If invoked with no arguments prints the short help for all\n"
"commands known to the command interpreter including hidden\n"
"commands (those whose name starts with _).\n"
"\n"
"Command options:\n"
"\n"
"    -f\n"
"\n"
"Prints for each command the long help."},
/* 35 */ {"process_model",
"Command process_model: performs the batch steps and then\n"
"returns control to the interactive shell.\n"
"\n"
"usage: process_model [-h] [-f] [-r] [-i model-file] [-m\n"
"Method]\n"
"\n"
"Reads the model, compiles it into BDD and performs the model\n"
"checking of all the specification contained in it. If the\n"
"environment variable forward_search has been set before,\n"
"then the set of reachable states is computed. If the option\n"
"-r is specified, the reordering of variables is performed\n"
"accordingly. This command simulates the batch behavior of\n"
"NuSMV and then returns the control to the interactive shell.\n"
"\n"
"Command options:\n"
"\n"
"    -f\n"
"\n"
"    Forces model construction even when COI is enabled.\n"
"\n"
"    -r\n"
"\n"
"    Performs a variable ordering at the end of the\n"
"computation, and dumps the variable ordering as the command\n"
"line option -reorder does.\n"
"\n"
"    -i model-file\n"
"\n"
"    Sets the environment variable input_file to file model-\n"
"file, and reads the model from file model-file.\n"
"\n"
"    -m Method\n"
"\n"
"    Sets the environment variable partition_method to Method\n"
"and uses it as partitioning method."},
/* 36 */ {"flatten_hierarchy",
"Command flatten_hierarchy: flattens the hierarchy of modules\n"
"\n"
"usage: flatten_hierarchy [-h] [-d]\n"
"\n"
"This command is responsible of the instantiation of modules\n"
"and processes. The instantiation is performed by\n"
"substituting the actual parameters for the formal\n"
"parameters, and then by prefixing the result via the\n"
"instance name.\n"
"\n"
"Command options:\n"
"\n"
"    -d\n"
"\n"
"    Delays the construction of vars constraints until needed"},
/* 37 */ {"show_vars",
"Command show_vars: shows model's symbolic variables and\n"
"their values\n"
"\n"
"usage: show_vars [-h] [-s] [-f] [-i] [-v] [-t|-V] [-m | -o\n"
"output-file]\n"
"\n"
"Prints symbolic input, frozen and state variables of the\n"
"model with their range of values (as defined in the input\n"
"file).\n"
"\n"
"Command options:\n"
"\n"
"    -s\n"
"\n"
"    Prints state variables.\n"
"\n"
"    -f\n"
"\n"
"    Prints frozen variables.\n"
"\n"
"    -i\n"
"\n"
"    Prints input variables.\n"
"\n"
"    -t\n"
"\n"
"    Prints only the number of variables (among selected\n"
"kinds), grouped by type. Incompatible with -V.\n"
"\n"
"    -V\n"
"\n"
"    Prints only the list of variables with their types\n"
"(among selected kinds), and no other summary information.\n"
"Incompatible with -t.\n"
"\n"
"    -D\n"
"\n"
"    Prints only the list of defines. Incompatible with -V.\n"
"\n"
"    -v\n"
"\n"
"    Prints verbosely. With this option, all scalar variable\n"
"values are printed\n"
"\n"
"    -m\n"
"\n"
"    Pipes the output to the program specified by the PAGER\n"
"shell variable if defined, else through the UNIX command\n"
"\"more\".\n"
"\n"
"    -o output-file\n"
"\n"
"    Writes the output generated by the command to output-\n"
"file\n"
"\n"
"By default, if no type specifiers (-s, -f, -i) are used, all\n"
"variables type will be printed. When using one or more type\n"
"specifiers (e.g. -s), only variables belonging to selected\n"
"types will be printed."},
/* 38 */ {"encode_variables",
"Command encode_variables: builds the BDD variables necessary\n"
"to compile the model into BDD.\n"
"\n"
"usage: encode_variables [-h] [-i order-file]\n"
"\n"
"Generates the boolean BDD variables and the ADD needed to\n"
"encode propositionally the (symbolic) variables declared in\n"
"the model.\n"
"\n"
"The variables are created as default in the order in which\n"
"they appear in a depth first traversal of the hierarchy.\n"
"\n"
"The input order file can be partial and can contain\n"
"variables not declared in the model. Variables not declared\n"
"in the model are simply discarded. Variables declared in the\n"
"model which are not listed in the ordering input file will\n"
"be created and appended at the end of the given ordering\n"
"list, according to the default ordering.\n"
"\n"
"Command options:\n"
"\n"
"    -i order-file\n"
"\n"
"    Sets the environment variable input_order_file to order-\n"
"file, and reads the variable ordering to be used from file\n"
"order-file. This can be combined with the write_order\n"
"command. The variable ordering is written to a file, which\n"
"can be inspected and reordered by the user, and then read\n"
"back in."},
/* 39 */ {"build_model",
"Command build_model: compiles the flattened hierarchy into\n"
"BDD\n"
"\n"
"usage: build_model [-h] [-f] [-m Method]\n"
"\n"
"Compiles the flattened hierarchy into BDD (initial states,\n"
"invariants, and transition relation) using the method\n"
"specified in the environment variable partition_method for\n"
"building the transition relation.\n"
"\n"
"Command options:\n"
"\n"
"    -m Method\n"
"\n"
"    Sets the environment variable partition_method to the\n"
"value Method, and then builds the transition relation.\n"
"Available methods are Monolithic, Threshold and Iwls95CP.\n"
"\n"
"    -f\n"
"\n"
"    Forces model construction. By default, only one\n"
"partition method is allowed. This option allows to overcome\n"
"this default, and to build the transition relation with\n"
"different partitioning methods."},
/* 40 */ {"build_flat_model",
"Command build_flat_model: compiles the flattened hierarchy\n"
"into SEXP\n"
"\n"
"usage: build_flat_model [-h]\n"
"\n"
"Compiles the flattened hierarchy into SEXP (initial states,\n"
"invariants, and transition relation)."},
/* 41 */ {"build_boolean_model",
"Command build_boolean_model: compiles the flattened\n"
"hierarchy into boolean SEXP\n"
"\n"
"usage: build_boolean_model [-h] [-f]\n"
"\n"
"Compiles the flattened hierarchy into boolean SEXP (initial\n"
"states, invariants, and transition relation)."},
/* 42 */ {"write_order",
"Command write_order: writes variable order to file.\n"
"\n"
"usage: write_order [-h] [-b] [(-o | -f) order-file]\n"
"\n"
"Writes the current order of BDD variables in the file\n"
"specified via the -o option. If no option is specified the\n"
"environment variable output_order_file will be considered.\n"
"If the variable output_order_file is unset (or set to an\n"
"empty value) then standard output will be used. The option\n"
"-b forces the dumped variable ordering to contain only\n"
"boolean variables. All the scalar variables will be\n"
"substituted by those variables bits that encode them. The\n"
"variables bits will occur within the dumped variable\n"
"ordering depending on the position they have within the\n"
"system when the command is executed.\n"
"\n"
"Command options:\n"
"\n"
"    -b\n"
"\n"
"    Dumps bits of scalar variables instead of the single\n"
"scalar variables. When specified, this option temporary\n"
"overloads the current value of the system variable\n"
"write_order_dumps_bits.\n"
"\n"
"    -o order-file\n"
"\n"
"    Sets the environment variable output_order_file to\n"
"order-file and then dumps the ordering list into that file.\n"
"\n"
"    -f order-file\n"
"\n"
"    Alias for -o option. Supplied for backward\n"
"compatibility."},
/* 43 */ {"print_fsm_stats",
"Command print_fsm_stats: prints out information about the\n"
"fsm and clustering.\n"
"\n"
"usage: print_fsm_stats [-h] | [-m] | [-p] | [-o output-file]\n"
"\n"
"This command prints out information regarding the fsm and\n"
"each cluster. In particular for each cluster it prints out\n"
"the cluster number, the size of the cluster (in BDD nodes),\n"
"the variables occurring in it, the size of the cube that has\n"
"to be quantified out relative to the cluster and the\n"
"variables to be quantified out.\n"
"\n"
"Also the command can print all the normalized predicates the\n"
"FMS consists of. A normalized predicate is a boolean\n"
"expression which does not have other boolean sub-\n"
"expressions. For example, expression (b<0 ? a/b : 0) = c is\n"
"normalized into (b<0 ? a/b=c : 0=c) which has 3 normalized\n"
"predicates inside: b<0, a/b=c, 0=c.\n"
"\n"
"Command options:\n"
"\n"
"    -m\n"
"\n"
"    Pipes the output generated by the command through the\n"
"program specified by the PAGER shell variable if defined, or\n"
"through the UNIX utility \"more\".\n"
"\n"
"    -p\n"
"\n"
"    Prints out the normalized predicates the FSM consists\n"
"of.\n"
"\n"
"    -o output-file\n"
"\n"
"    Redirects the generated output to the file output-file."},
/* 44 */ {"go",
"Command go: initializes the system for the verification.\n"
"\n"
"usage: go [-h][-f]\n"
"\n"
"This command initializes the system for verification. It is\n"
"equivalent to the command sequence read_model,\n"
"flatten_hierarchy, build_flat_model, encode_variables,\n"
"build_model.\n"
"\n"
"If some commands have already been executed, then only the\n"
"remaining ones will be invoked.\n"
"\n"
"Command options:\n"
"\n"
"    -f\n"
"\n"
"    Forces the model contruction.\n"
"\n"
"    -h\n"
"\n"
"    Prints the command usage."},
/* 45 */ {"go_bmc",
"Command go_bmc: initializes the system for the BMC\n"
"verification.\n"
"\n"
"usage: go_bmc [-h] | [-f]\n"
"\n"
"This command initializes the system for verification. It is\n"
"equivalent to the command sequence read_model,\n"
"flatten_hierarchy, encode_variables, build_boolean_model,\n"
"bmc_setup. If some commands have already been executed, then\n"
"only the remaining ones will be invoked.\n"
"\n"
"Command options:\n"
"\n"
"    -f\n"
"\n"
"    Forces the model construction.\n"
"\n"
"    -h\n"
"\n"
"    Prints the command usage."},
/* 46 */ {"get_internal_status",
"Command get_internal_status: returns the internal status of\n"
"the system.\n"
"\n"
"usage: get_internal_status [-h]\n"
"\n"
"    Prints out the internal status of the system. i.e.\n"
"\n"
"    - -1 : read_model has not yet been executed or an error\n"
"occurred during its execution.\n"
"\n"
"    - 0 : flatten_hierarchy has not yet been executed or an\n"
"error occurred during its execution.\n"
"\n"
"    - 1 : encode_variables has not yet been executed or an\n"
"error occurred during its execution.\n"
"\n"
"    - 2 : build_model has not yet been executed or an error\n"
"occurred during its execution.\n"
"\n"
"Command options:\n"
"\n"
"    -h\n"
"\n"
"    Prints the command usage."},
/* 47 */ {"write_flat_model",
"Command write_flat_model: writes a flat model of a given SMV\n"
"file\n"
"\n"
"usage: write_flat_model [-h] [-o filename] [-A] [-m]\n"
"\n"
"Processes are eliminated and a corresponding equivalent\n"
"model is printed out. If no file is specified, the file\n"
"specified with the environment variable\n"
"output_flatten_model_file is used if any, otherwise standard\n"
"output is used as output.\n"
"\n"
"Command options:\n"
"\n"
"    -o filename\n"
"\n"
"    Attempts to write the flat SMV model in filename.\n"
"\n"
"    -A\n"
"\n"
"    Write the model using variables and defines rewriting to\n"
"make it anonimized.\n"
"\n"
"    -m\n"
"\n"
"    Disable printing of key map when writing anonimized\n"
"model"},
/* 48 */ {"write_flat_model_udg",
"Command write_flat_model_udg: writes a flat model of a given\n"
"SMV file in uDraw format\n"
"\n"
"usage: write_flat_model_udg [-h] [-o filename]\n"
"\n"
"Processes are eliminated and a corresponding equivalent\n"
"model is printed out. If no file is specified, the file\n"
"specified with the environment variable\n"
"output_flatten_model_file is used if any, otherwise standard\n"
"output is used as output.\n"
"\n"
"Command options:\n"
"\n"
"    -o filename\n"
"\n"
"    Attempts to write the flat SMV model in filename."},
/* 49 */ {"write_boolean_model",
"Command write_boolean_model: writes a flattened and\n"
"booleanized model of a given SMV file\n"
"\n"
"usage: write_boolean_model [-h] [-o filename]\n"
"\n"
"Writes the currently loaded SMV model in the specified file,\n"
"after having flattened and booleanized it. Processes are\n"
"eliminated and a corresponding equivalent model is printed\n"
"out. If no file is specified, the file specified via the\n"
"environment variable output_boolean_model_file is used if\n"
"any, otherwise standard output is used.\n"
"\n"
"Command options:\n"
"\n"
"    -o filename\n"
"\n"
"    Attempts to write the flat and boolean SMV model in\n"
"filename.\n"
"\n"
"** New in 2.4.0 and later ** Scalar variables are dumped as\n"
"DEFINEs whose body is their boolean encoding. This allows\n"
"the user to still express and see parts of the generated\n"
"boolean model in terms of the original model's scalar\n"
"variables names and values, and still keeping the generated\n"
"model purely boolean. Also, symbolic constants are dumped\n"
"within a CONSTANTS statement to declare the values of the\n"
"original scalar variables' for future reading of the\n"
"generated file."},
/* 50 */ {"write_coi_model",
"Command write_coi_model: writes a flat model of SMV file,\n"
"restricted to the COI of the model properties\n"
"\n"
"usage: write_coi_model [-h] [-o filename] [-n | -p | -P ] |\n"
"[-c] | [-l] | [-i] | [-s] | [-q] | [-p expr] | [-C] | [-g]\n"
"\n"
"Writes the currently loaded SMV model in the specified file,\n"
"after having flattened it. If a property is specified, the\n"
"dumped model is the result of applying the COI over that\n"
"property. otherwise, a restricted SMV model is dumped for\n"
"each property in the property database. Processes are\n"
"eliminated and a corresponding equivalent model is printed\n"
"out. If no file is specified, stderr is used for output\n"
"\n"
"Command options:\n"
"\n"
"    -o filename\n"
"\n"
"    Attempts to write the flat and boolean SMV model in\n"
"filename.\n"
"\n"
"    -c\n"
"\n"
"    Dumps COI model for all CTL properties\n"
"\n"
"    -l\n"
"\n"
"    Dumps COI model for all LTL properties\n"
"\n"
"    -i\n"
"\n"
"    Dumps COI model for all INVAR properties\n"
"\n"
"    -s\n"
"\n"
"    Dumps COI model for all PSL properties\n"
"\n"
"    -q\n"
"\n"
"    Dumps COI model for all COMPUTE properties\n"
"\n"
"    -p expr\n"
"\n"
"    Applies COI for the given expression \"expr\"\n"
"\n"
"    -n idx\n"
"\n"
"    Applies COI for property stored at index \"idx\"\n"
"\n"
"    -P name\n"
"\n"
"    Applies COI for property named \"name\" idx\n"
"\n"
"    -C\n"
"\n"
"    Only prints the list of variables that are in the COI of\n"
"properties\n"
"\n"
"    -g\n"
"\n"
"    Dumps the COI model that represents the union of all COI\n"
"properties"},
/* 51 */ {"show_dependencies",
"Command show_dependencies: shows the expression dependencies\n"
"\n"
"usage: show_dependencies [-h] [-k bound] -e expr\n"
"\n"
"Shows the dependencies of the given expression\n"
"\n"
"Command options:\n"
"\n"
"    -k bound\n"
"\n"
"    Stop dependencies computation at step \"bound\"\n"
"\n"
"    -e expr\n"
"\n"
"    The expression on which the dependencies are computed on"},
/* 52 */ {"dynamic_var_ordering",
"Command dynamic_var_ordering: deals with the dynamic\n"
"variable ordering.\n"
"\n"
"usage: dynamic_var_ordering [-d] [-e <method>] [-f <method>]\n"
"[-h]\n"
"\n"
"Controls the application and the modalities of (dynamic)\n"
"variable ordering. Dynamic ordering is a technique to\n"
"reorder the BDD variables to reduce the size of the existing\n"
"BDDs. When no options are specified, the current status of\n"
"dynamic ordering is displayed. At most one of the options\n"
"-e, -f, and -d should be specified.\n"
"\n"
"Dynamic ordering may be time consuming, but can often reduce\n"
"the size of the BDDs dramatically. A good point to invoke\n"
"dynamic ordering explicitly (using the -f option) is after\n"
"the commands build_model, once the transition relation has\n"
"been built. It is possible to save the ordering found using\n"
"write_order in order to reuse it (using build_model -i\n"
"order-file) in the future.\n"
"\n"
"Command options:\n"
"\n"
"    -d\n"
"\n"
"    Disable dynamic ordering from triggering automatically.\n"
"\n"
"    -e <method>\n"
"\n"
"        Enable dynamic ordering to trigger automatically\n"
"whenever a certain threshold on the overall BDD size is\n"
"reached. <method> must be one of the following:\n"
"\n"
"        - sift: Moves each variable throughout the order to\n"
"find an optimal position for that variable (assuming all\n"
"other variables are fixed). This generally achieves greater\n"
"size reductions than the window method, but is slower.\n"
"\n"
"        - random: Pairs of variables are randomly chosen,\n"
"and swapped in the order. The swap is performed by a series\n"
"of swaps of adjacent variables. The best order among those\n"
"obtained by the series of swaps is retained. The number of\n"
"pairs chosen for swapping equals the number of variables in\n"
"the diagram.\n"
"\n"
"        - random_pivot: Same as random, but the two\n"
"variables are chosen so that the first is above the variable\n"
"with the largest number of nodes, and the second is below\n"
"that variable. In case there are several variables tied for\n"
"the maximum number of nodes, the one closest to the root is\n"
"used.\n"
"\n"
"        - sift_converge: The sift method is iterated until\n"
"no further improvement is obtained.\n"
"\n"
"        - symmetry_sift: This method is an implementation of\n"
"symmetric sifting. It is similar to sifting, with one\n"
"addition: Variables that become adjacent during sifting are\n"
"tested for symmetry. If they are symmetric, they are linked\n"
"in a group. Sifting then continues with a group being moved,\n"
"instead of a single variable.\n"
"\n"
"        - symmetry_sift_converge: The symmetry_sift method\n"
"is iterated until no further improvement is obtained.\n"
"\n"
"        - window{2,3,4}: Permutes the variables within\n"
"windows of \"n\" adjacent variables, where \"n\" can be either\n"
"2, 3 or 4, so as to minimize the overall BDD size.\n"
"\n"
"        - window{2,3,4}_converge: The window{2,3,4} method\n"
"is iterated until no further improvement is obtained.\n"
"\n"
"        - group_sift: This method is similar to\n"
"symmetry_sift, but uses more general criteria to create\n"
"groups.\n"
"\n"
"        - group_sift_converge: The group_sift method is\n"
"iterated until no further improvement is obtained.\n"
"\n"
"        - annealing: This method is an implementation of\n"
"simulated annealing for variable ordering. This method is\n"
"potentially very slow.\n"
"\n"
"        - genetic: This method is an implementation of a\n"
"genetic algorithm for variable ordering. This method is\n"
"potentially very slow.\n"
"\n"
"        - exact: This method implements a dynamic\n"
"programming approach to exact reordering. It only stores a\n"
"BDD at a time. Therefore, it is relatively efficient in\n"
"terms of memory. Compared to other reordering strategies, it\n"
"is very slow, and is not recommended for more than 16\n"
"boolean variables.\n"
"\n"
"        - linear: This method is a combination of sifting\n"
"and linear transformations.\n"
"\n"
"        - linear_converge: The linear method is iterated\n"
"until no further improvement is obtained.\n"
"\n"
"    -f <method>\n"
"\n"
"    Force dynamic ordering to be invoked immediately. The\n"
"values for <method> are the same as in option -e."},
/* 53 */ {"set_bdd_parameters",
"Command set_bdd_parameters: creates a table with the value\n"
"of all currently active NuSMV flags and change accordingly\n"
"the configurable parameters of the BDD package.\n"
"\n"
"usage: set_bdd_parameters [-h] [-s]\n"
"\n"
"Applies the variables table of the NuSMV environnement to\n"
"the BDD package, so the user can set specific BDD parameters\n"
"to the given value. This command works in conjunction with\n"
"the print_bdd_stats and set commands.\n"
"\n"
"print_bdd_stats first prints a report of the parameters and\n"
"statistics of the current bdd_manager. By using the command\n"
"set, the user may modify the value of any of the parameters\n"
"of the underlying BDD package. The way to do it is by\n"
"setting a value in the variable BDD.parameter name where\n"
"parameter name is the name of the parameter exactly as\n"
"printed by the print_bdd_stats command.\n"
"\n"
"Command options:\n"
"\n"
"    -s\n"
"\n"
"    Prints the BDD parameter and statistics after the\n"
"modification."},
/* 54 */ {"print_bdd_stats",
"Command print_bdd_stats: prints out the BDD statistics and\n"
"parameters\n"
"\n"
"usage: print_bdd_stats [-h]\n"
"\n"
"Prints the statistics for the BDD package. The amount of\n"
"information depends on the BDD package configuration\n"
"established at compilation time. The configurtion parameters\n"
"are printed out too. More information about statistics and\n"
"parameters can be found in the documentation of the CUDD\n"
"Decision Diagram package."},
/* 55 */ {"clean_sexp2bdd_cache",
"Command clean_sexp2bdd_cache: cleans the cache used during\n"
"evaluation of expressions to ADD and BDD representations.\n"
"\n"
"usage: clean_sexp2bdd_cache [-h]\n"
"\n"
"During conversion of symbolic (node_ptr) expressions to ADD\n"
"and BDD representations the results of evaluations are\n"
"normally cached (see additionally NuSMV option\n"
"enable_sexp2bdd_caching). This allows to save time by avoid\n"
"the construction of BDD for the same expression several\n"
"time. In some situations it may be preferable to clean the\n"
"cache and free collected ADD and BDD. This operation can be\n"
"done, for example, to free some memory. Another possible\n"
"reason is that dynamic reordering may modify all existing\n"
"BDDs, and cleaning the cache thereby freeing the BDD may\n"
"speed up the reordering. This command is designed\n"
"specifically to free the internal cache of evaluated\n"
"expressions and their ADDs and BDDs. Note that only the\n"
"cache of exp-to-bdd evaluator is freed. BDDs of variables,\n"
"constants and expressions collected in BDD FSM or anywhere\n"
"else are not touched."},
/* 56 */ {"print_formula",
"Command print_formula: prints a formula\n"
"\n"
"usage: print_formula [-h] | [-v] | [-f ]\n"
"\n"
"In formula mode, the formula as the canonical formula is\n"
"printed. In verbose mode, the explicit assignments\n"
"satisfying the formula are printed. Prints the number of\n"
"satsfying assignments for the given formula.\n"
"\n"
"    Command options:\n"
"\n"
"    -v\n"
"\n"
"    Verbosely prints the list of assignments satisfying the\n"
"formula.\n"
"\n"
"    -f\n"
"\n"
"    Prints a canonical representation of input."},
/* 57 */ {"dump_expr",
"Command dump_expr: dumps a given expression (which can be\n"
"contextualized) in the specified format. Example of\n"
"supported format is 'dot'.\n"
"\n"
"usage: dump_expr [-h] | -e -f [-o ]\n"
"\n"
"    Dumps an expression in the specified output format.\n"
"Command options:\n"
"\n"
"    -e expression\n"
"\n"
"    The required expression to be dumped.\n"
"\n"
"    -f format\n"
"\n"
"    The format to be used when dumping. Examples are dot,\n"
"davinci.\n"
"\n"
"    -o filename\n"
"\n"
"    The name of the output file (default: standard output)"},
/* 58 */ {"check_fsm",
"Command check_fsm: checks the transition relation for\n"
"totality.\n"
"\n"
"usage: check_fsm [-h] [-m | -o output-file]\n"
"\n"
"Checks if the transition relation is total. If the\n"
"transition relation is not total then a potential deadlock\n"
"state is shown out.\n"
"\n"
"Command options:\n"
"\n"
"    -m\n"
"\n"
"    Pipes the output generated by the command to the program\n"
"specified by the PAGER shell variable if defined, else\n"
"through the UNIX command \"more\".\n"
"\n"
"    -o output-file\n"
"\n"
"    Writes the output generated by the command to the file\n"
"output-file.\n"
"\n"
"At the beginning reachable states are computed in order to\n"
"guarantee that deadlock states are actually reachable."},
/* 59 */ {"compute_reachable",
"Command compute_reachable: computes the set of reachable\n"
"states\n"
"\n"
"usage: compute_reachable [-h] [-k number]\n"
"\n"
"The set of reachable states is used to simplify image and\n"
"preimage computations. This can result in improved\n"
"performances for models with sparse state spaces.\n"
"\n"
"Command options:\n"
"\n"
"    -k number\n"
"\n"
"    Provides an explicit bound to perform at most \"number\"\n"
"steps.\n"
"\n"
"    -t number\n"
"\n"
"    Provides a fail cut-off maximum CPU time to halt the\n"
"computation. This option can be used to limit execution\n"
"time."},
/* 60 */ {"print_reachable_states",
"Command print_reachable_states: prints out information about\n"
"reachable states\n"
"\n"
"usage: print_reachable_states [-h] [-v] [-f] [-d] [-o\n"
"filename]\n"
"\n"
"Prints the number of reachable states of the given model. In\n"
"verbose mode, prints also the list of all reachable states.\n"
"The reachable states are computed if needed.\n"
"\n"
"    Command options:\n"
"\n"
"    -v\n"
"\n"
"    Verbosely prints the list of reachable states.\n"
"\n"
"    -f\n"
"\n"
"    Print the list of reachable states as a formula.\n"
"\n"
"    -d\n"
"\n"
"    Prints the list of reachable states with defines\n"
"(Requires -v).\n"
"\n"
"    -o filename\n"
"\n"
"    Prints the result on the specified filename instead of\n"
"on standard output"},
/* 61 */ {"print_fair_states",
"Command print_fair_states: prints out information about fair\n"
"states\n"
"\n"
"usage: print_fair_states [-h] [-v]\n"
"\n"
"This command provides information about the fair states of\n"
"the current model.number of fair states. In verbose mode,\n"
"prints also the list of fair states.\n"
"\n"
"    Command options:\n"
"\n"
"    -v\n"
"\n"
"    Verbosely prints the list of fair states."},
/* 62 */ {"print_fair_transitions",
"Command print_fair_transitions: prints the number of fair\n"
"transitions, and list transitions in verbose mode.\n"
"\n"
"usage: print_fair_transitions [-h] [-v [-f format] [-o\n"
"fname]]\n"
"\n"
"Prints the number of fair transitions. In verbose mode,\n"
"prints also the list of fair transitions.\n"
"\n"
"    Command options:\n"
"\n"
"    -v\n"
"\n"
"    Verbosely prints the list of fair transitions.\n"
"\n"
"    -f\n"
"\n"
"    Use given format when printing the list of fair\n"
"transitions.\n"
"\n"
"    -o fname\n"
"\n"
"    Writes to given filename (default: stderr)."},
/* 63 */ {"dump_fsm",
"Command dump_fsm: dumps (in DOT format) selected parts of\n"
"the bdd fsm, with optional expression\n"
"\n"
"usage: dump_fsm [-h] -o filename [-i] [-I] [-t] [-f] [-r]\n"
"[-e expression]\n"
"\n"
"Dumps selected parts of the bdd fsm, with optional\n"
"expression, in DOT format. At least one among options [iIte]\n"
"must be specified. Command options:\n"
"\n"
"-o filename\n"
"\n"
"Dumps to the specified file name.\n"
"\n"
"-i\n"
"\n"
"Dumps the initial states of the FSM, among with other\n"
"selected outputs.\n"
"\n"
"-I\n"
"\n"
"Dumps the invariant states of the FSM, among with other\n"
"selected outputs.\n"
"\n"
"-t\n"
"\n"
"Dumps the (monolithic) transition relation of the FSM, among\n"
"with other selected outputs.\n"
"\n"
"-F\n"
"\n"
"Dumps the (monolithic) fair states of the FSM, among with\n"
"other selected outputs.\n"
"\n"
"-r\n"
"\n"
"Dumps the (monolithic) reachable states of the FSM, among\n"
"with other selected outputs.\n"
"\n"
"-e\n"
"\n"
"Dumps the specified expression, among with other selected\n"
"outputs (see also command dump_expr)."},
/* 64 */ {"hrc_write_model",
"Command hrc_write_model: writes the hrc structure from root\n"
"node to a given SMV file\n"
"\n"
"usage: hrc_write_model [-h] | [-o \"filename\"] [-d]\n"
"\n"
"Writes the currently loaded SMV model stored in hrc\n"
"structure in the specified file. If no file is specified the\n"
"standard output is used.\n"
"\n"
"    Command options:\n"
"\n"
"    -o \"filename\"\n"
"\n"
"    Attempts to write the SMV model in \"filename\".\n"
"\n"
"    -d\n"
"\n"
"    Renames modules appending \"_hrc\" the the original module\n"
"name."},
/* 65 */ {"hrc_dump_model",
"Command hrc_dump_model: writes the hrc structure from root\n"
"node to a given SMV file\n"
"\n"
"usage: hrc_dump_model [-h] | [-o \"filename\"] [-d]\n"
"\n"
"Writes the currently loaded SMV model stored in hrc\n"
"structure in the specified file. If no file is specified the\n"
"standard output is used.\n"
"\n"
"    Command options:\n"
"\n"
"    -f \"format\"\n"
"\n"
"    Dumps in the given format (debug, smv or xml).\n"
"\n"
"    -o \"filename\"\n"
"\n"
"    Dumps output to \"filename\"\n"
"\n"
"    -d\n"
"\n"
"    Renames every module name appending the suffix \"_hrc\"\n"
"\n"
"    -i\n"
"\n"
"    Disable indentation."},
/* 66 */ {"check_ltlspec",
"Command check_ltlspec: performs LTL model checking\n"
"\n"
"usage: check_ltlspec [-h] [-m | -o output-file] [-n number |\n"
"-p \"ltl-expr [IN context]\" | -P \"name\"]\n"
"\n"
"Performs model checking of LTL formulas. LTL model checking\n"
"is reduced to CTL model checking as described in the paper\n"
"by [CGH97].\n"
"\n"
"A ltl-expr to be checked can be specified at command line\n"
"using option -p. Alternatively, option -n can be used for\n"
"checking a particular formula in the property database. If\n"
"neither -n nor -p are used, all the LTLSPEC formulas in the\n"
"database are checked.\n"
"\n"
"Command options:\n"
"\n"
"    -m\n"
"\n"
"    Pipes the output generated by the command in processing\n"
"LTLSPECs to the program specified by the PAGER shell\n"
"variable if defined, else through the Unix command \"more\".\n"
"\n"
"    -o output-file\n"
"\n"
"    Writes the output generated by the command in processing\n"
"LTLSPECs to the file output-file.\n"
"\n"
"    -p \"ltl-expr [IN context]\"\n"
"\n"
"    An LTL formula to be checked. context is the module\n"
"instance name which the variables in ltl_expr must be\n"
"evaluated in.\n"
"\n"
"    -n number\n"
"\n"
"    Checks the LTL property with index number in the\n"
"property database.\n"
"\n"
"    -P name\n"
"\n"
"    Checks the LTL property named name in the property\n"
"database."},
/* 67 */ {"check_ctlspec",
"Command check_ctlspec: performs fair CTL model checking.\n"
"\n"
"usage: check_ctlspec [-h] [-m | -o output-file] [-n number |\n"
"-p \"ctl-expr [IN context]\" | -P \"name\"]\n"
"\n"
"Performs fair CTL model checking.\n"
"\n"
"A ctl-expr to be checked can be specified at command line\n"
"using option -p. Alternatively, option -n or -P can be used\n"
"for checking a particular formula in the property database.\n"
"If neither -n nor -p are used, all the SPEC formulas in the\n"
"database are checked.\n"
"\n"
"Command options:\n"
"\n"
"    -m\n"
"\n"
"    Pipes the output generated by the command in processing\n"
"SPECs to the program specified by the PAGER shell variable\n"
"if defined, else through the UNIX command \"more\".\n"
"\n"
"    -o output-file\n"
"\n"
"    Writes the output generated by the command in processing\n"
"SPECs to the file output-file.\n"
"\n"
"    -p \"ctl-expr [IN context]\"\n"
"\n"
"    A CTL formula to be checked. context is the module\n"
"instance name which the variables in ctl-expr must be\n"
"evaluated in.\n"
"\n"
"    -n number\n"
"\n"
"    Checks the CTL property with index number in the\n"
"property database.\n"
"\n"
"    -P name\n"
"\n"
"    Checks the CTL property with name name in the property\n"
"database.\n"
"\n"
"If the ag_only_search environment variable has been set, and\n"
"the set of reachable states has already been computed, then\n"
"a specialized algorithm to check AG formulas is used instead\n"
"of the standard model checking algorithms."},
/* 68 */ {"check_invar",
"Command check_invar: performs model checking of invariants\n"
"\n"
"usage: check_invar [-h] [-m | -o output-file] [-s\n"
"\"strategy\"] [-e \"heuristic\"] [-t number] [-k number] [-j\n"
"\"heuristic\"] [-n number | -p \"invar-expr [IN context]\" | -P\n"
"\"name\"]\n"
"\n"
"Performs invariant checking on the given model. An invariant\n"
"is a set of states. Checking the invariant is the process of\n"
"determining that all states reachable from the initial\n"
"states lie in the invariant. Invariants to be verified can\n"
"be provided as simple formulas (without any temporal\n"
"operators) in the input file via the INVARSPEC keyword or\n"
"directly at command line, using the option -p.\n"
"\n"
"Option -n can be used for checking a particular invariant of\n"
"the model. If neither -n nor -p are used, all the invariants\n"
"are checked.\n"
"\n"
"During checking of invariant all the fairness conditions\n"
"associated with the model are ignored.\n"
"\n"
"If an invariant does not hold, a proof of failure is\n"
"demonstrated. This consists of a path starting from an\n"
"initial state to a state lying outside the invariant. This\n"
"path has the property that it is the shortest path leading\n"
"to a state outside the invariant.\n"
"\n"
"Command options:\n"
"\n"
"    -m\n"
"\n"
"    Pipes the output generated by the program in processing\n"
"INVARSPECs to the program specified by the PAGER shell\n"
"variable if defined, else through the UNIX command \"more\".\n"
"\n"
"    -o output-file\n"
"\n"
"    Writes the output generated by the command in processing\n"
"INVARSPECs to the file output-file.\n"
"\n"
"    -s strategy\n"
"\n"
"    Force the analysis strategy.\n"
"\n"
"    -e heuristic\n"
"\n"
"    Force the search heuristic for the forward-backward\n"
"strategy.\n"
"\n"
"    -t number\n"
"\n"
"    When using the mixed BDD and BMC approach specify the\n"
"heuristic threshold.\n"
"\n"
"    -k number\n"
"\n"
"    When using the mixed BDD and BMC approach specify the\n"
"BMC max k.\n"
"\n"
"    -j heuristic\n"
"\n"
"    Force the switch heuristic for the BDD-BMC strategy.\n"
"\n"
"    -p \"invar-expr [IN context]\"\n"
"\n"
"    The command line specified invariant formula to be\n"
"verified. context is the module instance name which the\n"
"variables in invar-expr must be evaluated in.\n"
"\n"
"    -P name\n"
"\n"
"    Checks the INVARSPEC with name name in the property\n"
"database."},
/* 69 */ {"check_compute",
"Command check_compute: performs computation of quantitative\n"
"characteristics\n"
"\n"
"usage: check_compute [-h] [-m | -o output-file] [-n number |\n"
"-p \"compute-expr [IN context]\" | -P \"name\"]\n"
"\n"
"This command deals with the computation of quantitative\n"
"characteristics of real time systems. It is able to compute\n"
"the length of the shortest (longest) path from two given set\n"
"of states.\n"
"\n"
"MAX [ alpha , beta ]\n"
"\n"
"MIN [ alpha , beta ]\n"
"\n"
"Properties of the above form can be specified in the input\n"
"file via the keyword COMPUTE or directly at command line,\n"
"using option -p.\n"
"\n"
"Option -n can be used for computing a particular expression\n"
"in the model. If neither -n nor -p nor -P are used, all the\n"
"COMPUTE specifications are computed.\n"
"\n"
"Command options:\n"
"\n"
"    -m\n"
"\n"
"    Pipes the output generated by the command in processing\n"
"COMPUTEs to the program specified by the PAGER shell\n"
"variable if defined, else through the UNIX command \"more\".\n"
"\n"
"    -o output-file\n"
"\n"
"    Writes the output generated by the command in processing\n"
"COMPUTEs to the file output-file.\n"
"\n"
"    -p \"compute-expr [IN context]\"\n"
"\n"
"    A COMPUTE formula to be checked. context is the module\n"
"instance name which the variables in compute-expr must be\n"
"evaluated in.\n"
"\n"
"    -n number\n"
"\n"
"    Computes only the property with index number\n"
"\n"
"    -P name\n"
"\n"
"    Computes only the property named name"},
/* 70 */ {"compute",
"Command compute: performs computation of quantitative\n"
"characteristics\n"
"\n"
"usage: compute\n"
"\n"
"This command is deprecated. It has been substituted by the\n"
"command check_compute."},
/* 71 */ {"check_pslspec",
"Command check_pslspec: performs fair PSL model checking.\n"
"\n"
"usage: check_pslspec [-h] [-m | -o output-file] [-n number |\n"
"-p \"psl-expr [IN context]\" | -P \"name\"]\n"
"\n"
"Performs fair PSL model checking.\n"
"\n"
"A psl-expr to be checked can be specified at command line\n"
"using option -p. Alternatively, option -n can be used for\n"
"checking a particular formula in the property database. If\n"
"neither -n nor -p are used, all the PSLSPEC formulas in the\n"
"database are checked.\n"
"\n"
"Command options:\n"
"\n"
"    -m\n"
"\n"
"    Pipes the output generated by the command in processing\n"
"SPECs to the program specified by the PAGER shell variable\n"
"if defined, else through the UNIX command \"more\".\n"
"\n"
"    -o output-file\n"
"\n"
"    Writes the output generated by the command in processing\n"
"PSLSPECs to the file output-file.\n"
"\n"
"    -p \"psl-expr [IN context]\"\n"
"\n"
"    A PSL formula to be checked. context is the module\n"
"instance name which the variables in ctl-expr must be\n"
"evaluated in.\n"
"\n"
"    -n number\n"
"\n"
"    Checks the PSL property with index number in the\n"
"property database.\n"
"\n"
"    -P name\n"
"\n"
"    Checks the PSL property named name in the property\n"
"database."},
/* 72 */ {"language_emptiness",
"Command language_emptiness: checks for language emptiness.\n"
"\n"
"usage: language_emptiness [-h] [-v] [-a]\n"
"\n"
"Checks for the language emptiness.\n"
"\n"
"If -a is given the check is performed by verifying whether\n"
"all initial states are included in the set of fair states.\n"
"If it is the case from all initial states there exists a\n"
"fair path and thus the language is not empty. On the other\n"
"hand, if no -a is specified, the check is performed by\n"
"verifying whether there exists at least one inital state\n"
"that is also a fair state. In this case there is an initial\n"
"state from which it starts a fair path and thus the lnaguage\n"
"is not empty. if -v is specified, then some information on\n"
"the set of initial states is printed out too."},
/* 73 */ {"set",
"Command set: sets an environment variable\n"
"\n"
"usage: set [-h] [<name>] [<value>]\n"
"\n"
"A variable environment is maintained by the command\n"
"interpreter. The \"set\" command sets a variable to a\n"
"particular value, and the \"unset\" command removes the\n"
"definition of a variable. If \"set\" is given no arguments, it\n"
"prints the current value of all variables.\n"
"\n"
"Command options:\n"
"\n"
"    -h\n"
"\n"
"    Prints the command usage.\n"
"\n"
"    <name>\n"
"\n"
"    Variable name\n"
"\n"
"    <value>\n"
"\n"
"    Value to be assigned to the variable.\n"
"\n"
"Interpolation of variables is allowed when using the set\n"
"command. The variables are referred to with the prefix of\n"
"'$'. So for example, what follows can be done to check the\n"
"value of a set variable:\n"
"\n"
"NuSMV> set foo bar\n"
"\n"
"NuSMV> echo $foo\n"
"\n"
"bar\n"
"\n"
"The last line \"bar\" will be the output produced by NuSMV.\n"
"\n"
"Variables can be extended by using the character ':' to\n"
"concatenate values. For example:\n"
"\n"
"NuSMV> set foo bar\n"
"\n"
"NuSMV> set foo $foo:foobar\n"
"\n"
"NuSMV> echo $foo\n"
"\n"
"bar:foobar\n"
"\n"
"The variable foo is extended with the value foobar .\n"
"\n"
"Whitespace characters may be present within quotes. However,\n"
"variable interpolation lays the restriction that the\n"
"characters ':' and '/' may not be used within quotes. This\n"
"is to allow for recursive interpolation. So for example, the\n"
"following is allowed\n"
"\n"
"NuSMV> set \"foo bar\" this\n"
"\n"
"NuSMV> echo $\"foo bar\"\n"
"\n"
"this\n"
"\n"
"The last line will be the output produced by NuSMV.\n"
"\n"
"But in the following, the value of the variable foo/bar will\n"
"not be interpreted correctly:\n"
"\n"
"NuSMV> set \"foo/bar\" this\n"
"\n"
"NuSMV> echo $\"foo/bar\"\n"
"\n"
"foo/bar\n"
"\n"
"If a variable is not set by the \"set\" command, then the\n"
"variable is returned unchanged.\n"
"\n"
"Different commands use environment information for different\n"
"purposes. The command interpreter makes use of the following\n"
"parameters:\n"
"\n"
"    autoexec\n"
"\n"
"    Defines a command string to be automatically executed\n"
"after every command processed by the command interpreter.\n"
"This is useful for things like timing commands, or tracing\n"
"the progress of optimization.\n"
"\n"
"    open_path\n"
"\n"
"    \"open_path\" (in analogy to the shell-variable PATH) is a\n"
"list of colon-separated strings giving directories to be\n"
"searched whenever a file is opened for read. Typically the\n"
"current directory (.) is the first item in this list. The\n"
"standard system library (typically $NUSMV_LIBRARY_PATH) is\n"
"always implicitly appended to the current path. This\n"
"provides a convenient short-hand mechanism for reaching\n"
"standard library files.\n"
"\n"
"    errstream\n"
"\n"
"    Standard error (normally stderr) can be re-directed to a\n"
"file by setting the variable errstream.\n"
"\n"
"    outstream\n"
"\n"
"    Standard output (normally stdout) can be re-directed to\n"
"a file by setting the variable outstream."},
/* 74 */ {"unset",
"Command unset: unsets an environment variable\n"
"\n"
"usage: unset [-h] <variables>\n"
"\n"
"A variable environment is maintained by the command\n"
"interpreter. The \"set\" command sets a variable to a\n"
"particular value, and the \"unset\" command removes the\n"
"definition of a variable.\n"
"\n"
"Command options:\n"
"\n"
"    -h\n"
"\n"
"    Prints the command usage.\n"
"\n"
"    <variables>\n"
"\n"
"    Variables to be unset"},
/* 75 */ {"read_model",
"Command read_model: reads a NuSMV file into NuSMV.\n"
"\n"
"usage: read_model [-h] [-i model-file]\n"
"\n"
"Reads a NuSMV file. If the -i option is not specified, it\n"
"reads from the file specified in the environment variable\n"
"input_file.\n"
"\n"
"Command options:\n"
"\n"
"    -i model-file\n"
"\n"
"    Sets the environment variable input_file to model-file,\n"
"and reads the model from the specified file."},
/* 76 */ {"show_property",
"Command show_property: shows the currently stored properties\n"
"\n"
"usage: show_property [-h] [[-c | -l | -i | -q] [-u | -t |\n"
"-f]] | [-n property_number] | [-P property_name] | [-s] [-m\n"
"| -o output-file] [-F format]\n"
"\n"
"    Shows the properties currently stored in the list of\n"
"properties. This list is initialized with the properties\n"
"(CTL, LTL, INVAR, COMPUTE) present in the input file, if\n"
"any; then all of the properties added by the user with the\n"
"relative check or add_property<\tt> commands are appended to\n"
"this list. For every property, the following informations\n"
"are displayed:\n"
"\n"
"    - the identifier of the property (a progressive number);\n"
"\n"
"    - the property formula;\n"
"\n"
"    - the type (CTL, LTL, INVAR, COMPUTE) the status of the\n"
"formula (Unchecked, True, False) or the result of the\n"
"quantitative expression, if any (it can be infinite);\n"
"\n"
"    - if the formula has been found to be false, the number\n"
"of the corresponding counterexample trace.\n"
"\n"
"By default, all the properties currently stored in the list\n"
"of properties are shown. Specifying the suitable options,\n"
"properties with a certain status (Unchecked, True, False)\n"
"and/or of a certain type (e.g. CTL, LTL), or with a given\n"
"identifier, it is possible to let the system show a\n"
"restricted set of properties. It is allowed to insert only\n"
"one option per status and one option per type.\n"
"\n"
"Command options:\n"
"\n"
"    -c\n"
"\n"
"    Prints only CTL properties.\n"
"\n"
"    -l\n"
"\n"
"    Prints only LTL properties.\n"
"\n"
"    -i\n"
"\n"
"    Prints only INVAR properties.\n"
"\n"
"    -q\n"
"\n"
"    Prints only quantitative (COMPUTE) properties.\n"
"\n"
"    -u\n"
"\n"
"    Prints only unchecked properties.\n"
"\n"
"    -t\n"
"\n"
"    Prints only those properties found to be true.\n"
"\n"
"    -f\n"
"\n"
"    Prints only those properties found to be false.\n"
"\n"
"    -n property-number\n"
"\n"
"    Prints out the property numbered property-number.\n"
"\n"
"    -P property-name\n"
"\n"
"    Prints out the property named property-name.\n"
"\n"
"    -m\n"
"\n"
"    Pipes the output through the program specified by the\n"
"PAGER shell variable if defined, else through the UNIX\n"
"\"more\" command.\n"
"\n"
"    -o output-file\n"
"\n"
"    Writes the output generated by the command to output-\n"
"file<\tt>.\n"
"\n"
"    -F format\n"
"\n"
"    print with given format. Use -F help to see available\n"
"formats.\n"
"\n"
"    -s Prints the number of stored properties.\n"
"\n"
"    <\tt>."},
/* 77 */ {"add_property",
"Command add_property: adds a property to the list of\n"
"properties\n"
"\n"
"usage: add_property [-h] [(-c | -l | -i | -q | -s) -p\n"
"\"formula [IN context]\"] [-n \"name\"]\n"
"\n"
"Adds a property in the list of properties. It is possible to\n"
"insert LTL, CTL, INVAR, PSL and quantitative (COMPUTE)\n"
"properties. Every newly inserted property is initialized to\n"
"unchecked. A type option must be given to properly execute\n"
"the command.\n"
"\n"
"Command options:\n"
"\n"
"    -c\n"
"\n"
"    Adds a CTL property.\n"
"\n"
"    -l\n"
"\n"
"    Adds an LTL property.\n"
"\n"
"    -i\n"
"\n"
"    Adds an INVAR property.\n"
"\n"
"    -s\n"
"\n"
"    Adds a PSL property.\n"
"\n"
"    -q\n"
"\n"
"    Adds a quantitative (COMPUTE) property.\n"
"\n"
"    -p \"formula [IN context]\"\n"
"\n"
"    Adds the formula specified on the command-line.\n"
"\n"
"    context is the module instance name which the variables\n"
"in formula must be evaluated in.\n"
"\n"
"    -n name\n"
"\n"
"    Names the added property as \"name\""},
/* 78 */ {"check_property",
"Command check_property: checks a property into the current\n"
"list of properties, or a newly specified property\n"
"\n"
"usage: check_property [-h] [-n number | -P \"name\"] | [(-c |\n"
"-l | -i | -s | -q ) [-p \"formula [IN context]\"]]\n"
"\n"
"Checks the specified property taken from the property list,\n"
"or adds the new specified property and checks it.\n"
"\n"
"Command options:\n"
"\n"
"    -h\n"
"\n"
"    Prints the help.\n"
"\n"
"    -c\n"
"\n"
"    Checks all the CTL properties not already checked\n"
"\n"
"    -l\n"
"\n"
"    Checks all the LTL properties not already checked\n"
"\n"
"    -i\n"
"\n"
"    Checks all the INVAR properties not already checked\n"
"\n"
"    -s\n"
"\n"
"    Checks all the PSL properties not already checked\n"
"\n"
"    -q\n"
"\n"
"    Checks all the COMPUTE properties not already checked\n"
"\n"
"    -n number\n"
"\n"
"    Checks the property with id number in the property list\n"
"if it exists.\n"
"\n"
"    -P name\n"
"\n"
"    Checks the property named named in the property list if\n"
"it exists.\n"
"\n"
"    -p \"formula [IN context]\"\n"
"\n"
"    Checks the formula specified on the command-line.\n"
"\n"
"    context is the module instance name which the variables\n"
"in formula must be evaluated in.\n"
"\n"
"If no property has been specified via -n or -p or -P, then\n"
"all the properties (of a given type) in the property list\n"
"will be evaluated."},
/* 79 */ {"convert_property_to_invar",
"Command convert_property_to_invar:\n"
"\n"
"usage: convert_property_to_invar [-n number | -P \"name\" |\n"
"-p \"formula\"]"},
/* 80 */ {"pick_state",
"Command pick_state: picks a state from the set of initial\n"
"states\n"
"\n"
"usage: pick_state [-h] [-v] [-r | -i [-a]] [-c \"constraints\"\n"
"| -s trace.state]\n"
"\n"
"Chooses an element from the set of initial states, and makes\n"
"it the current state (replacing the old one). The chosen\n"
"state is stored as the first state of a new trace ready to\n"
"be lengthened by steps states by the simulate command. The\n"
"state can be chosen according to different policies which\n"
"can be specified via command line options. By default the\n"
"state is chosen in a deterministic way.\n"
"\n"
"Command options:\n"
"\n"
"    -v\n"
"\n"
"    Verbosely prints out chosen state (all state variables,\n"
"otherwise it prints out only the label t.1 of the state\n"
"chosen, where t is the number of the new trace, that is the\n"
"number of traces so far generated plus one).\n"
"\n"
"    -r\n"
"\n"
"    Randomly picks a state from the set of initial states.\n"
"\n"
"    -i\n"
"\n"
"    Enables the user to interactively pick up an initial\n"
"state. The user is requested to choose a state from a list\n"
"of possible items (every item in the list doesn't show state\n"
"variables unchanged with respect to a previous item). If the\n"
"number of possible states is too high, then the user has to\n"
"specify some further constraints as \"simple expression\".\n"
"\n"
"    -a\n"
"\n"
"    Displays all state variables (changed and unchanged with\n"
"respect to a previous item) in an interactive picking. This\n"
"option works only if the -i options has been specified.\n"
"\n"
"    -c \"constraints\"\n"
"\n"
"    Uses constraints to restrict the set of initial states\n"
"in which the state has to be picked.\n"
"\n"
"    -S seed\n"
"\n"
"    Sets the seed for random simulation.\n"
"\n"
"    -s trace.state\n"
"\n"
"    Picks state from trace.state label. A new simulation\n"
"trace will be created by copying prefix of the source trace\n"
"up to specified state."},
/* 81 */ {"simulate",
"Command simulate: performs a simulation from the current\n"
"selected state\n"
"\n"
"usage: simulate [-h] [-p | -v] [-r | -i [-a]] [[-c\n"
"\"constraints\"] | [-t \"constraints\"] ] [-k steps]\n"
"\n"
"Generates a sequence of at most steps states (representing a\n"
"possible execution of the model), starting from the current\n"
"state. The current state must be set via the pick_state or\n"
"goto_state commands.\n"
"\n"
"It is possible to run the simulation in three ways\n"
"(according to different command line policies):\n"
"deterministic (the default mode), random and interactive.\n"
"\n"
"The resulting sequence is stored in a trace indexed with an\n"
"integer number taking into account the total number of\n"
"traces stored in the system. There is a different behavior\n"
"in the way traces are built, according to how current state\n"
"is set: current state is always put at the beginning of a\n"
"new trace (so it will contain at most steps + 1 states)\n"
"except when it is the last state of an existent old trace.\n"
"In this case the old trace is lengthened by at most steps\n"
"states.\n"
"\n"
"Command options:\n"
"\n"
"    -p\n"
"\n"
"    Prints current generated trace (only those variables\n"
"whose value changed from the previous state).\n"
"\n"
"    -v\n"
"\n"
"    Verbosely prints current generated trace (changed and\n"
"unchanged state variables).\n"
"\n"
"    -r\n"
"\n"
"    Picks a state from a set of possible future states in a\n"
"random way.\n"
"\n"
"    -i\n"
"\n"
"    Enables the user to interactively choose every state of\n"
"the trace, step by step. If the number of possible states is\n"
"too high, then the user has to specify some constraints as\n"
"simple expression. These constraints are used only for a\n"
"single simulation step and are forgotten in the following\n"
"ones. They are to be intended in an opposite way with\n"
"respect to those constraints eventually entered with the\n"
"pick_state command, or during an interactive simulation\n"
"session (when the number of future states to be displayed is\n"
"too high), that are local only to a single step of the\n"
"simulation and are forgotten in the next one.\n"
"\n"
"    -a\n"
"\n"
"    Displays all the state variables (changed and unchanged)\n"
"during every step of an interactive session. This option\n"
"works only if the -i option has been specified.\n"
"\n"
"    -c \"constraints\"\n"
"\n"
"    Performs a simulation in which computation is restricted\n"
"to states satisfying those constraints. The desired sequence\n"
"of states could not exist if such constraints were too\n"
"strong or it may happen that at some point of the simulation\n"
"a future state satisfying those constraints doesn't exist:\n"
"in that case a trace with a number of states less than steps\n"
"trace is obtained. The expression cannot contain next\n"
"operators, and is automatically shifted by one state in\n"
"order to constraint only the next steps\n"
"\n"
"    -t \"constraints\"\n"
"\n"
"    Performs a simulation in which computation is restricted\n"
"to states satisfying those constraints. The desired sequence\n"
"of states could not exist if such constraints were too\n"
"strong or it may happen that at some point of the simulation\n"
"a future state satisfying those constraints doesn't exist:\n"
"in that case a trace with a number of states less than steps\n"
"trace is obtained. The expression can contain next\n"
"operators, and is NOT automatically shifted by one state as\n"
"done with option -c\n"
"\n"
"    -k steps\n"
"\n"
"    Maximum length of the path according to the constraints.\n"
"The length of a trace could contain less than steps states:\n"
"this is the case in which simulation stops in an\n"
"intermediate step because it may not exist any future state\n"
"satisfying those constraints.\n"
"\n"
"    -S seed\n"
"\n"
"    Sets the seed for random simulation."},
/* 82 */ {"goto_state",
"Command goto_state: goes to a given state of a trace\n"
"\n"
"usage: goto_state [-h] state\n"
"\n"
"Makes state the current state. This command is used to\n"
"navigate alongs traces produced by NuSMV. During the\n"
"navigation, there is a current state, and the current trace\n"
"is the trace the current state belongs to. Command options:\n"
"\n"
"    state:\n"
"\n"
"    The state of a trace (trace.state) to be picked."},
/* 83 */ {"print_current_state",
"Command print_current_state: prints out the current state\n"
"\n"
"usage: print_current_state [-h] [-v]\n"
"\n"
"Prints the name of the current state if defined.\n"
"\n"
"Command options:\n"
"\n"
"    -v\n"
"\n"
"    Prints the value of all the state variables of the\n"
"current state."},
/* 84 */ {"show_traces",
"Command show_traces: shows the traces generated in a NuSMV\n"
"session\n"
"\n"
"usage: show_traces [ [-h] [-v] [-m | -o output-file] [-A] -t\n"
"| [-d] -a | trace_number[.from_state[:[to_state]]] ]\n"
"\n"
"Shows the traces currently stored in system memory, if any.\n"
"By default it shows the last generated trace, if any. A\n"
"trace number can be specified optionally followed by a slice\n"
"denoting the steps top be shown. Negative numbers can be\n"
"used to denote steps in a right-to-left fashion. (i.e. -1\n"
"denotes last step, -2 is the previous and so forth.)\n"
"\n"
"Command options:\n"
"\n"
"    -v\n"
"\n"
"    Verbosely prints traces content (all state variables,\n"
"otherwise it prints out only those variables that have\n"
"changed their value from previous state).\n"
"\n"
"    -t\n"
"\n"
"    Prints only the total number of currently stored traces.\n"
"\n"
"    -a\n"
"\n"
"    Prints all the currently stored traces.\n"
"\n"
"    -A\n"
"\n"
"    Prints traces in an anonimized form.\n"
"\n"
"    -d\n"
"\n"
"    Disables DEFINEs printout in traces\n"
"\n"
"    -p trace plugin\n"
"\n"
"    Uses the specified trace plugin to explain the trace.\n"
"\n"
"    -m\n"
"\n"
"    Pipes the output through the program specified by the\n"
"PAGER shell variable if defined, else through the UNIX\n"
"command \"more\".\n"
"\n"
"    -o output-file\n"
"\n"
"    Writes the output generated by the command to output-\n"
"file\n"
"\n"
"    trace_number\n"
"\n"
"    The (ordinal) identifier number of the trace to be\n"
"printed.\n"
"\n"
"    from_state\n"
"\n"
"    Denotes left end of the trace slice to be printed.\n"
"\n"
"    to_state\n"
"\n"
"    Denotes right end of the trace slice to be printed."},
/* 85 */ {"show_plugins",
"Command show_plugins: lists out all the available plugins\n"
"inside the system. In addition, it prints [D] in front of\n"
"the default plugin.\n"
"\n"
"usage: show_plugins [ [-h] [-n plugin_index| -a]]\n"
"CommandDescription [ Sets the default plugin to print\n"
"traces.\n"
"\n"
"Command options:\n"
"\n"
"    -h\n"
"\n"
"    Prints the usage of the command.\n"
"\n"
"    -n plugin_index\n"
"\n"
"    Prints the description message of the plugin at\n"
"specified index only.\n"
"\n"
"    -a\n"
"\n"
"    Prints all the available plugins with their description.\n"
"\n"
"] **********************************************************\n"
"*******************[EXTRACT_DOC_NOTE: * /]\n"
"\n"
"Sets the default plugin to print traces.\n"
"\n"
"Command options:\n"
"\n"
"    -h\n"
"\n"
"    Prints the usage of the command.\n"
"\n"
"    -n plugin_index\n"
"\n"
"    Prints the description message of the plugin at\n"
"specified index only.\n"
"\n"
"    -a\n"
"\n"
"    Prints all the available plugins with their description."},
/* 86 */ {"read_trace",
"Command read_trace: reads the trace from the specified file\n"
"into the memory\n"
"\n"
"usage: read_trace [-h] | [-i filename] | [-u] [-s] filename\n"
"\n"
"Reads a trace from a specified XML file into the memory.\n"
"\n"
"Command options:\n"
"\n"
"    -h\n"
"\n"
"    Prints the usage of the command.\n"
"\n"
"    -i filename\n"
"\n"
"    Specifies the name of the xml trace file to read\n"
"(deprecated).\n"
"\n"
"    -u\n"
"\n"
"    Turns 'undefined symbol' error in a warning.\n"
"\n"
"    -s\n"
"\n"
"    Turns 'wrong section' error in a warning.\n"
"\n"
"    filename\n"
"\n"
"    Specifies the name of the xml trace file to read"},
/* 87 */ {"execute_traces",
"Command execute_traces: executes complete traces on the\n"
"model FSM\n"
"\n"
"usage: execute_traces [-h] [-v] [-m | -o output-file] -e\n"
"engine [-a | trace_number]\n"
"\n"
"Executes traces stored in the Trace Manager. If no trace is\n"
"specified, last registered trace is executed. Traces must be\n"
"complete in order to perform execution.\n"
"\n"
"Command options:\n"
"\n"
"    -v\n"
"\n"
"    Verbosely prints traces execution steps\n"
"\n"
"    -a\n"
"\n"
"    Prints all the currently stored traces.\n"
"\n"
"    -m\n"
"\n"
"    Pipes the output through the program specified by the\n"
"PAGER shell variable if defined, else through the UNIX\n"
"command \"more\".\n"
"\n"
"    -o output-file\n"
"\n"
"    Writes the output generated by the command to output-\n"
"file\n"
"\n"
"    -e executor\n"
"\n"
"    Selects an executor for trace re-execution.\n"
"\n"
"    trace_number\n"
"\n"
"    The (ordinal) identifier number of the trace to be\n"
"printed."},
/* 88 */ {"execute_partial_traces",
"Command execute_partial_traces: executes partial traces on\n"
"the model FSM\n"
"\n"
"usage: execute_partial_traces [-h] [-v] [-r] [-m | -o\n"
"output-file] -e engine [-a | trace_number]\n"
"\n"
"Executes traces stored in the Trace Manager. If no trace is\n"
"specified, last registered trace is executed. Traces are not\n"
"required to be complete. Upon succesful termination, a new\n"
"complete trace is registered in the Trace Manager.\n"
"\n"
"Command options:\n"
"\n"
"    -v\n"
"\n"
"    Verbosely prints traces execution steps.\n"
"\n"
"    -a\n"
"\n"
"    Executes all the currently stored traces.\n"
"\n"
"    -r\n"
"\n"
"    Performs restart on complete states (deprecated).\n"
"\n"
"    -m\n"
"\n"
"    Pipes the output through the program specified by the\n"
"PAGER shell variable if defined, else through the UNIX\n"
"command \"more\".\n"
"\n"
"    -o output-file\n"
"\n"
"    Writes the output generated by the command to output-\n"
"file\n"
"\n"
"    -e engine\n"
"\n"
"    Selects an engine for trace re-execution. It must be one\n"
"of 'bdd', 'sat'.\n"
"\n"
"    trace_number\n"
"\n"
"    The (ordinal) identifier number of the trace to be\n"
"printed."},
/* 89 */ {"optional",
"Command optional: optional\n"
"\n"
"usage: optional optional\n"
"\n"
"optional"},
/* 90 */ {"optional",
"Command optional: optional\n"
"\n"
"usage: optional optional\n"
"\n"
"optional"}

};

/* this is computed by scripts/create_help.py -n */
int command_number=91;


/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/

/* functions helpful to manipulate the dynamic map */
void cmd_help_init(NuSMVEnv_ptr env)
{
  int i;
  hash_ptr help;
  if (!NuSMVEnv_has_value(env, ENV_CMD_HELP)) {
      NuSMVEnv_set_value(env, ENV_CMD_HELP, new_assoc_string_key());
  }

  help = NuSMVEnv_get_value(env, ENV_CMD_HELP);

  for (i=0; i<command_number; i++) {
    insert_assoc(help,
                 NODE_PTR(command_help[i].command_name),
                 NODE_PTR(command_help[i].command_description));
  }
}


void cmd_help_quit(NuSMVEnv_ptr env)
{
  hash_ptr help = (hash_ptr)NuSMVEnv_remove_value(env, ENV_CMD_HELP);
  free_assoc(help);
}


char* cmd_help_get(NuSMVEnv_ptr env, char* command_name)
{
  hash_ptr help = NuSMVEnv_get_value(env, ENV_CMD_HELP);
  char* command_description = (char*)find_assoc(help,NODE_PTR(command_name));
  return command_description;
}


void cmd_help_add(NuSMVEnv_ptr env,
                  const char* command_name,
                  const char* command_description)
{
  hash_ptr help = NuSMVEnv_get_value(env, ENV_CMD_HELP);
  insert_assoc(help, NODE_PTR(command_name), NODE_PTR(command_description));
}


void cmd_help_remove(NuSMVEnv_ptr env, char* command_name)
{
  hash_ptr help = NuSMVEnv_get_value(env, ENV_CMD_HELP);
  node_ptr command_removed = remove_assoc(help, NODE_PTR(command_name));
}
